/*
 * Decompiled with CFR 0.152.
 */
package ch.mobi.mobitor.service.config;

import ch.mobi.mobitor.domain.configgenerator.ScreenConfigGenerator;
import ch.mobi.mobitor.plugins.api.MobitorPlugin;
import ch.mobi.mobitor.plugins.api.domain.config.ExtendableScreenConfig;
import ch.mobi.mobitor.service.plugins.MobitorPluginsRegistry;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.stereotype.Component;

@Component
public class ExtendableScreenConfigService {
    private static final Logger LOG = LoggerFactory.getLogger(ExtendableScreenConfigService.class);
    private final MobitorPluginsRegistry pluginsRegistry;
    private final List<ScreenConfigGenerator> screenConfigGenerators;
    private List<ExtendableScreenConfig> configs = new ArrayList<ExtendableScreenConfig>();

    @Autowired
    public ExtendableScreenConfigService(MobitorPluginsRegistry pluginsRegistry, List<ScreenConfigGenerator> screenConfigGenerators) {
        this.pluginsRegistry = pluginsRegistry;
        this.screenConfigGenerators = screenConfigGenerators;
    }

    @PostConstruct
    public void initialize() {
        PathMatchingResourcePatternResolver pathResolver = new PathMatchingResourcePatternResolver();
        String resourceName = "";
        try {
            Resource[] resources = pathResolver.getResources("classpath*:screen/screen-*.json");
            for (Resource resource : resources) {
                resourceName = resource.getFilename();
                ExtendableScreenConfig conf = this.readConfig(resource);
                this.configs.add(conf);
            }
        }
        catch (IOException e) {
            LOG.error("Could not load screen-*.json config file [" + resourceName + "]!", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            LOG.error("Could not load screen-*.json config file [" + resourceName + "]!", (Throwable)e);
            throw e;
        }
        ArrayList<ExtendableScreenConfig> generatedScreenConfigs = new ArrayList<ExtendableScreenConfig>();
        if (CollectionUtils.isNotEmpty(this.screenConfigGenerators)) {
            for (ScreenConfigGenerator generator : this.screenConfigGenerators) {
                ExtendableScreenConfig extendableScreenConfig = generator.generateExtendableScreenConfig(this.configs);
                generatedScreenConfigs.add(extendableScreenConfig);
            }
        }
        this.configs.addAll(generatedScreenConfigs);
    }

    private ExtendableScreenConfig readConfig(Resource resource) {
        ExtendableScreenConfig extendableScreenConfig;
        block10: {
            ObjectMapper mapper = new ObjectMapper().registerModule((Module)new ParameterNamesModule()).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
            InputStream inputStream = resource.getInputStream();
            try {
                ExtendableScreenConfig screenConfig = (ExtendableScreenConfig)mapper.readValue(inputStream, ExtendableScreenConfig.class);
                String configKey = this.getConfigKey(resource.getFilename());
                screenConfig.setConfigKey(configKey);
                LOG.info(MessageFormat.format("successfully read screenconfig [{0}] with name [{1}]", configKey, screenConfig.getLabel()));
                Set orderedPluginKeySet = screenConfig.getPluginConfigs().keySet();
                for (String pluginKey : orderedPluginKeySet) {
                    MobitorPlugin plugin = this.pluginsRegistry.getPlugin(pluginKey);
                    if (plugin != null) {
                        JsonNode pluginConfigNode = screenConfig.getPluginConfigNode(pluginKey);
                        JsonParser jsonParser = mapper.treeAsTokens((TreeNode)pluginConfigNode);
                        Class pluginConfigClass = plugin.getConfigClass();
                        LOG.debug("Parsing screen config for plugin " + plugin.getConfigPropertyName() + " with config class: " + pluginConfigClass);
                        CollectionType typeReference = TypeFactory.defaultInstance().constructCollectionType(List.class, pluginConfigClass);
                        List pluginConfigObjList = (List)mapper.readValue(jsonParser, (JavaType)typeReference);
                        screenConfig.putPluginConfigList(pluginKey, pluginConfigObjList);
                        continue;
                    }
                    LOG.warn("Plugin with key not loaded: " + pluginKey);
                }
                extendableScreenConfig = screenConfig;
                if (inputStream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("config could not be read", e);
                }
            }
            inputStream.close();
        }
        return extendableScreenConfig;
    }

    public List<ExtendableScreenConfig> getConfigs() {
        return this.configs;
    }

    private String getConfigKey(String screenConfigFilename) {
        Pattern screenPattern = Pattern.compile(".*screen-([0-9a-z]+)\\.json");
        Matcher matcher = screenPattern.matcher(screenConfigFilename);
        matcher.find();
        String screenKey = matcher.group(1);
        return screenKey;
    }

    public ExtendableScreenConfig getScreenConfig(String configKey) {
        for (ExtendableScreenConfig screenConfig : this.configs) {
            if (!screenConfig.getConfigKey().equals(configKey)) continue;
            return screenConfig;
        }
        return null;
    }

    public List<ExtendableScreenConfig> getAllScreenConfigs() {
        return this.configs;
    }
}

