/*
 * Decompiled with CFR 0.152.
 */
package ch.mobi.mobitor.service.config;

import ch.mobi.mobitor.config.EnvironmentNetwork;
import java.util.Arrays;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringBootVersion;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="mobitor")
public class MobitorApplicationConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(MobitorApplicationConfiguration.class);
    private String version;
    private EnvironmentNetwork network;
    private String springBootVersion = SpringBootVersion.getVersion();
    private final Environment environment;

    @Autowired
    public MobitorApplicationConfiguration(Environment environment) {
        this.environment = environment;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public EnvironmentNetwork getNetwork() {
        return this.network;
    }

    public void setNetwork(EnvironmentNetwork network) {
        this.network = network;
    }

    @PostConstruct
    public void logValues() {
        LOG.info("Version: " + this.version);
        LOG.info("Network: " + this.network);
        LOG.info("Active Profiles: " + this.getActiveProfiles());
    }

    public String getActiveProfiles() {
        return Arrays.toString(this.environment.getActiveProfiles());
    }

    public String getSpringBootVersion() {
        return this.springBootVersion;
    }
}

