/*
 * Decompiled with CFR 0.152.
 */
package ch.mobi.mobitor.service.scheduling;

import ch.mobi.mobitor.model.EnvironmentTimestampModel;
import ch.mobi.mobitor.service.EnvironmentsConfigurationService;
import ch.mobi.mobitor.service.environment.EnvironmentTimestamps;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
@ConfigurationProperties(prefix="mobitor.timestamp.service")
public class EnvironmentTimestampCollector {
    private final EnvironmentTimestampModel environmentTimestampModel;
    private final EnvironmentsConfigurationService environmentsConfigurationService;
    private final RestTemplate restTemplate;
    private String userId;

    @Autowired
    public EnvironmentTimestampCollector(EnvironmentTimestampModel environmentTimestampModel, RestTemplate restTemplate, EnvironmentsConfigurationService environmentsConfigurationService) {
        this.environmentTimestampModel = environmentTimestampModel;
        this.restTemplate = restTemplate;
        this.environmentsConfigurationService = environmentsConfigurationService;
    }

    @Scheduled(fixedDelayString="${scheduling.pollingIntervalMs.environmentTimestampInterval}", initialDelayString="${scheduling.pollingInitialDelayMs.second}")
    public void collectDb2Timestamp() {
        List environments = this.environmentsConfigurationService.getEnvironments();
        environments.stream().filter(environmentConfig -> StringUtils.isNotEmpty((CharSequence)environmentConfig.getTimestampUrl())).forEach(envConf -> {
            String url = envConf.getTimestampUrl();
            HttpEntity request = new HttpEntity((MultiValueMap)this.getHeaders());
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, request, EnvironmentTimestamps.class, new Object[0]);
            this.environmentTimestampModel.updateTimestamp(envConf.getEnvironment(), (EnvironmentTimestamps)response.getBody());
        });
    }

    private HttpHeaders getHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(List.of(MediaType.APPLICATION_JSON));
        headers.add("x-user-id", this.userId);
        headers.add("x-caller", "Mobitor");
        headers.add("x-corr-id", UUID.randomUUID().toString());
        return headers;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }
}

