/*
 * Decompiled with CFR 0.152.
 */
package ch.mobi.mobitor;

import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="scheduling")
public class SchedulingConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(SchedulingConfiguration.class);
    private PollingIntervalMs pollingIntervalMs;
    private PollingInitialDelayMs pollingInitialDelayMs;

    @PostConstruct
    public void logValues() {
        LOG.info("Polling interval Rest-Services:               " + this.pollingIntervalMs.restServicePollingInterval);
        LOG.info("Polling interval Liima:                       " + this.pollingIntervalMs.liimaInformationPollingInterval);
        LOG.info("Polling interval Nexus IQ:                    " + this.pollingIntervalMs.nexusIqInformationPollingInterval);
        LOG.info("Polling interval Sonar:                       " + this.pollingIntervalMs.sonarInformationPollingInterval);
        LOG.info("Polling interval TeamCity Build (Status):     " + this.pollingIntervalMs.teamCityBuildStatusInformationPollingInterval);
        LOG.info("Polling interval TeamCity Project (Status):   " + this.pollingIntervalMs.teamCityProjectStatusInformationPollingInterval);
        LOG.info("Polling interval TeamCity Coverage:           " + this.pollingIntervalMs.teamCityCoverageInformationPollingInterval);
        LOG.info("Polling interval Jira:                        " + this.pollingIntervalMs.jiraPollingInterval);
        LOG.info("Polling interval Kubernetes:                  " + this.pollingIntervalMs.kubernetesPodsInterval);
        LOG.info("Polling interval ALM:                         " + this.pollingIntervalMs.almPollingInterval);
        LOG.info("Polling interval BitBucket:                   " + this.pollingIntervalMs.bitBucketPollingInterval);
        LOG.info("Polling interval Kubernetes batch jobs:       " + this.pollingIntervalMs.kubernetesBatchJobInformationPollingInterval);
        LOG.info("Polling interval SWD deployments:             " + this.pollingIntervalMs.swdDeploymentInformationPollingInterval);
        LOG.info("Polling interval Zaproxy deployments:         " + this.pollingIntervalMs.zaproxyInformationPollingInterval);
        LOG.info("Polling interval EDWH deployments:            " + this.pollingIntervalMs.edwhDeploymentInformationPollingInterval);
        LOG.info("Polling interval DWH deployments:             " + this.pollingIntervalMs.dwhDeploymentInformationPollingInterval);
        LOG.info("Polling initial first delay:  {}", (Object)this.pollingInitialDelayMs.first);
        LOG.info("Polling initial second delay: {}", (Object)this.pollingInitialDelayMs.second);
        LOG.info("Polling initial third delay:  {}", (Object)this.pollingInitialDelayMs.third);
    }

    public PollingIntervalMs getPollingIntervalMs() {
        return this.pollingIntervalMs;
    }

    public void setPollingIntervalMs(PollingIntervalMs pollingIntervalMs) {
        this.pollingIntervalMs = pollingIntervalMs;
    }

    public PollingInitialDelayMs getPollingInitialDelayMs() {
        return this.pollingInitialDelayMs;
    }

    public void setPollingInitialDelayMs(PollingInitialDelayMs pollingInitialDelayMs) {
        this.pollingInitialDelayMs = pollingInitialDelayMs;
    }

    public static class PollingInitialDelayMs {
        private long first;
        private long second;
        private long third;

        public long getFirst() {
            return this.first;
        }

        public void setFirst(long first) {
            this.first = first;
        }

        public long getSecond() {
            return this.second;
        }

        public void setSecond(long second) {
            this.second = second;
        }

        public long getThird() {
            return this.third;
        }

        public void setThird(long third) {
            this.third = third;
        }
    }

    public static class PollingIntervalMs {
        private long restServicePollingInterval;
        private long liimaInformationPollingInterval;
        private long nexusIqInformationPollingInterval;
        private long sonarInformationPollingInterval;
        private long teamCityBuildStatusInformationPollingInterval;
        private long teamCityProjectStatusInformationPollingInterval;
        private long teamCityCoverageInformationPollingInterval;
        private long jiraPollingInterval;
        private long kubernetesPodsInterval;
        private long almPollingInterval;
        private long bitBucketPollingInterval;
        private long kubernetesBatchJobInformationPollingInterval;
        private long swdDeploymentInformationPollingInterval;
        private long zaproxyInformationPollingInterval;
        private long edwhDeploymentInformationPollingInterval;
        private long dwhDeploymentInformationPollingInterval;
        private long environmentTimestampInterval;

        public long getRestServicePollingInterval() {
            return this.restServicePollingInterval;
        }

        public void setRestServicePollingInterval(long restServicePollingInterval) {
            this.restServicePollingInterval = restServicePollingInterval;
        }

        public long getLiimaInformationPollingInterval() {
            return this.liimaInformationPollingInterval;
        }

        public void setLiimaInformationPollingInterval(long liimaInformationPollingInterval) {
            this.liimaInformationPollingInterval = liimaInformationPollingInterval;
        }

        public long getNexusIqInformationPollingInterval() {
            return this.nexusIqInformationPollingInterval;
        }

        public void setNexusIqInformationPollingInterval(long nexusIqInformationPollingInterval) {
            this.nexusIqInformationPollingInterval = nexusIqInformationPollingInterval;
        }

        public long getSonarInformationPollingInterval() {
            return this.sonarInformationPollingInterval;
        }

        public void setSonarInformationPollingInterval(long sonarInformationPollingInterval) {
            this.sonarInformationPollingInterval = sonarInformationPollingInterval;
        }

        public long getTeamCityBuildStatusInformationPollingInterval() {
            return this.teamCityBuildStatusInformationPollingInterval;
        }

        public void setTeamCityBuildStatusInformationPollingInterval(long teamCityBuildStatusInformationPollingInterval) {
            this.teamCityBuildStatusInformationPollingInterval = teamCityBuildStatusInformationPollingInterval;
        }

        public long getTeamCityProjectStatusInformationPollingInterval() {
            return this.teamCityProjectStatusInformationPollingInterval;
        }

        public void setTeamCityProjectStatusInformationPollingInterval(long teamCityProjectStatusInformationPollingInterval) {
            this.teamCityProjectStatusInformationPollingInterval = teamCityProjectStatusInformationPollingInterval;
        }

        public long getTeamCityCoverageInformationPollingInterval() {
            return this.teamCityCoverageInformationPollingInterval;
        }

        public void setTeamCityCoverageInformationPollingInterval(long teamCityCoverageInformationPollingInterval) {
            this.teamCityCoverageInformationPollingInterval = teamCityCoverageInformationPollingInterval;
        }

        public long getJiraPollingInterval() {
            return this.jiraPollingInterval;
        }

        public void setJiraPollingInterval(long jiraPollingInterval) {
            this.jiraPollingInterval = jiraPollingInterval;
        }

        public long getKubernetesPodsInterval() {
            return this.kubernetesPodsInterval;
        }

        public void setKubernetesPodsInterval(long kubernetesPodsInterval) {
            this.kubernetesPodsInterval = kubernetesPodsInterval;
        }

        public long getAlmPollingInterval() {
            return this.almPollingInterval;
        }

        public void setAlmPollingInterval(long almPollingInterval) {
            this.almPollingInterval = almPollingInterval;
        }

        public long getBitBucketPollingInterval() {
            return this.bitBucketPollingInterval;
        }

        public void setBitBucketPollingInterval(long bitBucketPollingInterval) {
            this.bitBucketPollingInterval = bitBucketPollingInterval;
        }

        public long getKubernetesBatchJobInformationPollingInterval() {
            return this.kubernetesBatchJobInformationPollingInterval;
        }

        public void setKubernetesBatchJobInformationPollingInterval(long kubernetesBatchJobInformationPollingInterval) {
            this.kubernetesBatchJobInformationPollingInterval = kubernetesBatchJobInformationPollingInterval;
        }

        public long getSwdDeploymentInformationPollingInterval() {
            return this.swdDeploymentInformationPollingInterval;
        }

        public void setSwdDeploymentInformationPollingInterval(long swdDeploymentInformationPollingInterval) {
            this.swdDeploymentInformationPollingInterval = swdDeploymentInformationPollingInterval;
        }

        public long getZaproxyInformationPollingInterval() {
            return this.zaproxyInformationPollingInterval;
        }

        public void setZaproxyInformationPollingInterval(long zaproxyInformationPollingInterval) {
            this.zaproxyInformationPollingInterval = zaproxyInformationPollingInterval;
        }

        public long getEdwhDeploymentInformationPollingInterval() {
            return this.edwhDeploymentInformationPollingInterval;
        }

        public void setEdwhDeploymentInformationPollingInterval(long edwhDeploymentInformationPollingInterval) {
            this.edwhDeploymentInformationPollingInterval = edwhDeploymentInformationPollingInterval;
        }

        public long getDwhDeploymentInformationPollingInterval() {
            return this.dwhDeploymentInformationPollingInterval;
        }

        public void setDwhDeploymentInformationPollingInterval(long dwhDeploymentInformationPollingInterval) {
            this.dwhDeploymentInformationPollingInterval = dwhDeploymentInformationPollingInterval;
        }

        public long getEnvironmentTimestampInterval() {
            return this.environmentTimestampInterval;
        }

        public void setEnvironmentTimestampInterval(long environmentTimestampInterval) {
            this.environmentTimestampInterval = environmentTimestampInterval;
        }
    }
}

