/*
 * Decompiled with CFR 0.152.
 */
package ch.mobi.mobitor.service.scheduling;

import ch.mobi.mobitor.model.EnvironmentTimestampModel;
import ch.mobi.mobitor.service.EnvironmentsConfigurationService;
import ch.mobi.mobitor.service.environment.EnvironmentTimestamps;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class EnvironmentTimestampCollector {
    private final EnvironmentTimestampModel environmentTimestampModel;
    private final EnvironmentsConfigurationService environmentsConfigurationService;
    private final RestTemplate restTemplate;

    @Autowired
    public EnvironmentTimestampCollector(EnvironmentTimestampModel environmentTimestampModel, RestTemplate restTemplate, EnvironmentsConfigurationService environmentsConfigurationService) {
        this.environmentTimestampModel = environmentTimestampModel;
        this.restTemplate = restTemplate;
        this.environmentsConfigurationService = environmentsConfigurationService;
    }

    @Scheduled(fixedDelayString="${scheduling.pollingIntervalMs.environmentTimestampInterval}", initialDelayString="${scheduling.pollingInitialDelayMs.second}")
    public void collectDb2Timestamp() {
        List environments = this.environmentsConfigurationService.getEnvironments();
        environments.stream().filter(environmentConfig -> StringUtils.isNotEmpty((CharSequence)environmentConfig.getTimestampUrl())).forEach(envConf -> {
            String url = envConf.getTimestampUrl();
            EnvironmentTimestamps envTimestamps = (EnvironmentTimestamps)this.restTemplate.getForObject(url, EnvironmentTimestamps.class, new Object[0]);
            this.environmentTimestampModel.updateTimestamp(envConf.getEnvironment(), envTimestamps);
        });
    }
}

