/*
 * Decompiled with CFR 0.152.
 */
package ch.mobi.mobitor.model;

import ch.mobi.mobitor.config.EnvironmentConfigProperties;
import ch.mobi.mobitor.config.EnvironmentPipeline;
import ch.mobi.mobitor.domain.screen.Screen;
import ch.mobi.mobitor.domain.screen.ServerContext;
import ch.mobi.mobitor.domain.screen.information.VersionInformation;
import ch.mobi.mobitor.plugin.dwh.domain.DwhDeploymentsInformation;
import ch.mobi.mobitor.plugin.edwh.domain.EdwhDeploymentsInformation;
import ch.mobi.mobitor.plugin.hpalm.domain.AlmInformation;
import ch.mobi.mobitor.plugin.jira.domain.JiraInformation;
import ch.mobi.mobitor.plugin.kubernetes.domain.KubernetesBatchJobInformation;
import ch.mobi.mobitor.plugin.liima.config.AppServerConfig;
import ch.mobi.mobitor.plugin.liima.domain.LiimaInformation;
import ch.mobi.mobitor.plugin.liima.service.ServersConfigurationService;
import ch.mobi.mobitor.plugin.nexusiq.domain.NexusIqInformation;
import ch.mobi.mobitor.plugin.nexusiq.service.scheduling.NexusIqConfigurationService;
import ch.mobi.mobitor.plugin.rest.domain.FlywayRestServiceResponse;
import ch.mobi.mobitor.plugin.rest.domain.RestCallInformation;
import ch.mobi.mobitor.plugin.sonarqube.domain.SonarInformation;
import ch.mobi.mobitor.plugin.sonarqube.rule.SonarReportLimitsRule;
import ch.mobi.mobitor.plugin.streamworks.domain.StreamworksLastRunStatusInformation;
import ch.mobi.mobitor.plugin.streamworks.domain.StreamworksStatusInformation;
import ch.mobi.mobitor.plugin.swd.domain.SwdDeploymentInformation;
import ch.mobi.mobitor.plugin.teamcity.domain.TeamCityBuildInformation;
import ch.mobi.mobitor.plugin.teamcity.domain.TeamCityCoverageInformation;
import ch.mobi.mobitor.plugin.teamcity.domain.TeamCityProjectInformation;
import ch.mobi.mobitor.plugin.teamcity.rule.TeamCityCoverageLimitsRule;
import ch.mobi.mobitor.plugin.zaproxy.domain.ZaproxyInformation;
import ch.mobi.mobitor.plugins.api.domain.screen.information.ApplicationInformation;
import ch.mobi.mobitor.service.EnvironmentsConfigurationService;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ScreenViewHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ScreenViewHelper.class);
    private final ServersConfigurationService serversConfigurationService;
    private final EnvironmentsConfigurationService environmentsConfigurationService;
    private final SonarReportLimitsRule sonarReportLimitsRule;
    private final NexusIqConfigurationService nexusIqConfigurationService;
    private final TeamCityCoverageLimitsRule teamCityCoverageLimitRules;

    @Autowired
    public ScreenViewHelper(ServersConfigurationService serversConfigurationService, SonarReportLimitsRule sonarReportLimitsRule, EnvironmentsConfigurationService environmentsConfigurationService, NexusIqConfigurationService nexusIqConfigurationService, TeamCityCoverageLimitsRule teamCityCoverageLimitRules) {
        this.serversConfigurationService = serversConfigurationService;
        this.sonarReportLimitsRule = sonarReportLimitsRule;
        this.environmentsConfigurationService = environmentsConfigurationService;
        this.nexusIqConfigurationService = nexusIqConfigurationService;
        this.teamCityCoverageLimitRules = teamCityCoverageLimitRules;
    }

    public String getCssClassForServer(LiimaInformation liimaInformation) {
        if (liimaInformation == null || liimaInformation.getState() == null) {
            return "server-unknown";
        }
        switch (liimaInformation.getState()) {
            case "success": {
                return "server-success";
            }
            case "failed": {
                return "server-error";
            }
            case "canceled": 
            case "rejected": {
                return "server-abort";
            }
        }
        return "server-working";
    }

    private boolean isRunning(String state) {
        return "running".equals(state);
    }

    private String getCssClassForBuild(String status, String state) {
        Object cssClass = "";
        switch (status) {
            case "SUCCESS": {
                cssClass = (String)cssClass + "build-success";
                break;
            }
            case "FAILURE": {
                cssClass = (String)cssClass + "build-error";
                break;
            }
            default: {
                cssClass = (String)cssClass;
            }
        }
        if (this.isRunning(state)) {
            cssClass = (String)cssClass + " build-running";
        }
        return cssClass;
    }

    public String getCssClassForProject(TeamCityProjectInformation teamCityProjectInformation) {
        if (teamCityProjectInformation == null || teamCityProjectInformation.getStatus() == null) {
            return "build-unknown";
        }
        return this.getCssClassForBuild(teamCityProjectInformation.getStatus(), teamCityProjectInformation.isRunning() ? "running" : "finished");
    }

    public String getCssClassForBuild(TeamCityBuildInformation tcInformation) {
        if (tcInformation == null || tcInformation.getStatus() == null) {
            return "build-unknown";
        }
        return this.getCssClassForBuild(tcInformation.getStatus(), tcInformation.getState());
    }

    public String getEnvironmentClass(String environment) {
        EnvironmentPipeline environmentPipeline = this.environmentsConfigurationService.getPipeline(environment);
        switch (environmentPipeline) {
            case AGILE: {
                return "deliveryEnvironmentAgile";
            }
            case CONVENTIONAL: {
                return "deliveryEnvironmentConventional";
            }
        }
        return "deliveryEnvironment";
    }

    public String getApplicationScreenName(String applicationName) {
        String screenName = this.serversConfigurationService.getApplicationScreenName(applicationName);
        if (!StringUtils.isBlank((CharSequence)screenName)) {
            return screenName;
        }
        if (applicationName.startsWith("ch_mobi_")) {
            return StringUtils.substringAfter((String)applicationName, (String)"ch_mobi_");
        }
        return applicationName;
    }

    public String getServerScreenName(String serverName) {
        AppServerConfig appServerConfig = (AppServerConfig)this.serversConfigurationService.getAppServerNameToConfigMap().get(serverName);
        return appServerConfig != null ? appServerConfig.getLabel() : serverName;
    }

    public String getVersionFromVersionInformation(ServerContext serverContext, String applicationName) {
        String version = "";
        List matchingInfoList = serverContext.getMatchingInformationByApplicationName(applicationName);
        if (CollectionUtils.isNotEmpty((Collection)matchingInfoList)) {
            for (ApplicationInformation appInfo : matchingInfoList) {
                if (!(appInfo instanceof VersionInformation)) continue;
                VersionInformation vi = (VersionInformation)appInfo;
                version = vi.getVersion();
            }
            return version;
        }
        LOG.debug("Could not determine version for application: " + applicationName);
        return version;
    }

    public EnvironmentConfigProperties getEnvironmentConfig(String environment) {
        return this.environmentsConfigurationService.getEnvironmentConfig(environment);
    }

    public String getSonarCssClass(SonarInformation sonarInformation) {
        return this.sonarReportLimitsRule.ruleViolated(sonarInformation) ? "sonarViolated" : "sonarConform";
    }

    public String getCoverageCssClass(TeamCityCoverageInformation teamCityCoverageInformation) {
        return this.teamCityCoverageLimitRules.ruleViolated(teamCityCoverageInformation) ? "statusError" : "statusOk";
    }

    public String getRestCssClass(RestCallInformation restInformation) {
        if (restInformation.getRestServiceResponses().size() == 0) {
            return "rest-unknown";
        }
        if (restInformation.hasAnyErrors()) {
            return "rest-error";
        }
        return "rest-success";
    }

    public long getNumberOfRestErrors(Screen screen) {
        List restCallInfos = screen.getMatchingInformation("rest");
        long nbrOfErrors = restCallInfos.stream().mapToLong(RestCallInformation::getNumberOfErrors).sum();
        return nbrOfErrors;
    }

    public long getTotalNumberOfRestCalls(Screen screen) {
        List restCallInfos = screen.getMatchingInformation("rest");
        long nbrOfRestCalls = restCallInfos.stream().mapToLong(RestCallInformation::getNumberOfRestCalls).sum();
        return nbrOfRestCalls;
    }

    public String getRestErrorsCssGradient(long errors, long max) {
        if (max == 0L) {
            return "";
        }
        long percentage = errors * 100L / max;
        return String.format("background: linear-gradient(to right, red %1$d%%, green %1$d%%);", percentage);
    }

    public String getCssClassForNexusIq(NexusIqInformation nexusIqInformation) {
        if (nexusIqInformation == null || !nexusIqInformation.isInformationUpdated() || nexusIqInformation.hasError()) {
            return "nexus-iq-unknown";
        }
        if (nexusIqInformation.getNexusIqViolations() == 0) {
            return "nexus-iq-ok";
        }
        return "nexus-iq-error";
    }

    public String getPolicySummary(NexusIqInformation nexusIqInformation) {
        StringBuilder message = new StringBuilder();
        if (nexusIqInformation == null) {
            message.append("No information");
        } else if (!nexusIqInformation.isInformationUpdated()) {
            message.append(nexusIqInformation.getPublicId()).append(" not current");
        } else if (nexusIqInformation.hasError()) {
            message.append(nexusIqInformation.getPublicId()).append(" not found");
        } else if (nexusIqInformation.getViolationsMap().size() == 0) {
            message.append(nexusIqInformation.getPublicId()).append(": congratulations!");
        } else {
            Map violationsMap = nexusIqInformation.getViolationsMap();
            for (Map.Entry entry : violationsMap.entrySet()) {
                String policyId = (String)entry.getKey();
                Integer violations = (Integer)entry.getValue();
                String label = this.nexusIqConfigurationService.getLabel(policyId);
                message.append(label).append(": ").append(violations).append(" ");
            }
        }
        return message.toString();
    }

    public String getCssClassForZaproxy(ZaproxyInformation zaproxyInformation) {
        if (zaproxyInformation == null || !zaproxyInformation.isInformationUpdated()) {
            return "zaproxy-unknown";
        }
        if (zaproxyInformation.getHighNumber() > 0) {
            return "zaproxy-high";
        }
        if (zaproxyInformation.getMediumNumber() > 0) {
            return "zaproxy-medium";
        }
        if (zaproxyInformation.getLowNumber() > 0) {
            return "zaproxy-low";
        }
        if (zaproxyInformation.getInfoNumber() > 0) {
            return "zaproxy-info";
        }
        return "zaproxy-unknown";
    }

    public String getCssClassForJira(JiraInformation jiraInformation) {
        if (!jiraInformation.isInformationUpdated()) {
            return "jira-pending";
        }
        if (jiraInformation.getTotal() == 0L) {
            return "jira-ok";
        }
        if (jiraInformation.getCriticalIssues() > 0L) {
            return "jira-error";
        }
        if (jiraInformation.getMajorIssues() > 0L) {
            return "jira-warning";
        }
        return "jira-info";
    }

    public String getRestartCountClass(long restartCount) {
        if (restartCount <= 1L) {
            return "restarts-ok";
        }
        if (restartCount < 5L) {
            return "restarts-warning";
        }
        return "restarts-error";
    }

    public String getCssClassForDb(FlywayRestServiceResponse flywayResponse) {
        if ("FUTURE_SUCCESS".equals(flywayResponse.getState())) {
            return "flyway-almost-ok";
        }
        if ("SUCCESS".equals(flywayResponse.getState())) {
            return "flyway-ok";
        }
        if (StringUtils.isBlank((CharSequence)flywayResponse.getState())) {
            return "flyway-unknown";
        }
        return "flyway-error";
    }

    public FlywayRestServiceResponse getFlywayRestServiceResponse(RestCallInformation restCallInformation) {
        return FlywayRestServiceResponse.fromRestServiceResponses((List)restCallInformation.getRestServiceResponses());
    }

    public String getCssClassForAlm(AlmInformation almInformation) {
        if (almInformation.hasRuns() && almInformation.getNumberOfRuns() == almInformation.getPassedRuns()) {
            return "alm-ok";
        }
        if (almInformation.hasRuns() && almInformation.getNumberOfRuns() != almInformation.getPassedRuns()) {
            return "alm-error";
        }
        return "alm-unknown";
    }

    public String getKubernetesPodStatusCssClass(KubernetesBatchJobInformation information) {
        if (information != null && information.getStatus() != null) {
            switch (information.getStatus()) {
                case PENDING: {
                    return "statusRunning";
                }
                case RUNNING: {
                    return "statusRunning";
                }
                case SUCCEEDED: {
                    return "statusOk";
                }
                case FAILED: {
                    return "statusError";
                }
            }
        }
        return "statusUnknown";
    }

    public String getKubernetesPodStatusIconCssClass(KubernetesBatchJobInformation information) {
        if (information != null && information.getStatus() != null) {
            switch (information.getStatus()) {
                case PENDING: {
                    return "fa-pause-circle";
                }
                case RUNNING: {
                    return "fa-play-circle";
                }
                case SUCCEEDED: {
                    return "fa-check-circle";
                }
                case FAILED: {
                    return "fa-exclamation-circle";
                }
            }
        }
        return "fa-question-circle";
    }

    public String getSwdDeploymentStatusCssClass(SwdDeploymentInformation information) {
        if (information != null && information.getRevision() != null) {
            if (!information.getRevision().isEmpty()) {
                return "statusOk";
            }
            return "statusError";
        }
        return "statusUnknown";
    }

    public String getEdwhDeploymentStatusCssClass(EdwhDeploymentsInformation information) {
        return information != null && information.isSuccessful() ? "statusOk" : "statusError";
    }

    public String getDwhDeploymentStatusCssClass(DwhDeploymentsInformation information) {
        return information != null && information.isSuccessful() ? "statusOk" : "statusError";
    }

    public String getStreamworksStatusCssClass(StreamworksStatusInformation info) {
        if (info == null || info.getState() == null) {
            return "statusUnknown";
        }
        switch (info.getState()) {
            case PREPARED: 
            case RUNNING: {
                return "statusRunning";
            }
            case ABNORMALLY_ENDED: {
                return "statusError";
            }
            case COMPLETED: {
                return "statusOk";
            }
        }
        return "statusUnknown";
    }

    public String getStreamworksLastRunStatusCssClass(StreamworksLastRunStatusInformation info) {
        if (info == null || info.getState() == null) {
            return "statusUnknown";
        }
        switch (info.getState()) {
            case ABNORMALLY_ENDED: {
                return "statusError";
            }
            case COMPLETED: {
                return "statusOk";
            }
            case RUNNING: {
                return "statusRunning";
            }
        }
        return "statusUnknown";
    }
}

