/*
 * Decompiled with CFR 0.152.
 */
package ch.mobi.mobitor.config;

import ch.mobi.mobitor.config.ObjectMappers;
import io.netty.handler.ssl.SslContextBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.util.function.Consumer;
import javax.net.ssl.KeyManagerFactory;
import org.springframework.core.codec.Decoder;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.http.codec.ClientCodecConfigurer;
import org.springframework.http.codec.json.Jackson2JsonDecoder;
import org.springframework.util.MimeType;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.netty.http.client.HttpClient;

public class WebClients {
    private static final Consumer<ClientCodecConfigurer> jacksonConfigurer = ccc -> ccc.defaultCodecs().jackson2JsonDecoder((Decoder)new Jackson2JsonDecoder(ObjectMappers.standard(), new MimeType[0]));
    private static final WebClient standardClient = WebClients.standardBuilder().build();
    private static WebClient keyStoreClient = null;

    private WebClients() {
    }

    public static WebClient standard() {
        return standardClient;
    }

    public static WebClient withKeyStore() {
        return WebClients.keyStoreClient();
    }

    private static WebClient.Builder standardBuilder() {
        return WebClient.builder().exchangeStrategies(ExchangeStrategies.builder().codecs(jacksonConfigurer).build());
    }

    private static WebClient keyStoreClient() {
        if (keyStoreClient == null) {
            HttpClient httpClient = HttpClient.create().secure(spec -> {
                try {
                    String keyStoreLocation = System.getProperty("javax.net.ssl.keyStore");
                    String keyStorePassword = System.getProperty("javax.net.ssl.keyStorePassword");
                    KeyManagerFactory keyManagerFactory = null;
                    if (keyStoreLocation != null && keyStorePassword != null) {
                        String keyStoreType = System.getProperty("javax.net.ssl.keyStoreType", "JKS");
                        KeyStore keyStore = KeyStore.getInstance(keyStoreType);
                        keyStore.load(new FileInputStream(new File(keyStoreLocation)), keyStorePassword.toCharArray());
                        keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                        keyManagerFactory.init(keyStore, keyStorePassword.toCharArray());
                    }
                    spec.sslContext(SslContextBuilder.forClient().keyManager(keyManagerFactory).build());
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not setup SSL context", e);
                }
            });
            keyStoreClient = WebClients.standardBuilder().clientConnector((ClientHttpConnector)new ReactorClientHttpConnector(httpClient)).build();
        }
        return keyStoreClient;
    }
}

