package ch.mobi.mobitor.config;

/*-
 * §
 * mobitor-plugin-dwh
 * --
 * Copyright (C) 2019 Die Mobiliar
 * --
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * §§
 */

import org.springframework.http.codec.ClientCodecConfigurer;
import org.springframework.http.codec.json.Jackson2JsonDecoder;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import org.springframework.web.reactive.function.client.WebClient;

import java.util.function.Consumer;

public class WebClients {
    private static final Consumer<ClientCodecConfigurer> jacksonConfigurer = ccc ->
            ccc.defaultCodecs().jackson2JsonDecoder(new Jackson2JsonDecoder(ObjectMappers.standard()));
    private static final WebClient webClient = WebClient.builder()
            .exchangeStrategies(ExchangeStrategies.builder().codecs(jacksonConfigurer).build())
            .build();

    private WebClients() {
    }

    public static WebClient standard() {
        return webClient;
    }
}
