/*
 * Decompiled with CFR 0.152.
 */
package ch.nerdin.esbuild;

import ch.nerdin.esbuild.Config;
import ch.nerdin.esbuild.ConfigBuilder;
import ch.nerdin.esbuild.Execute;
import ch.nerdin.esbuild.resolve.ExecutableResolver;
import ch.nerdin.esbuild.util.ImportToPackage;
import ch.nerdin.esbuild.util.UnZip;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;

public class BundleDependencies {
    private static final String IMPORT_FILE_NAME = "META-INF/importmap.json";
    private static final String MVNPM_PACKAGE_PREFIX = "resources/_static";
    private static final String WEBJAR_PACKAGE_PREFIX = "META-INF/resources/webjars";
    public static final String ESBUILD_VERSION = "0.17.10";

    public Path bundle(List<Path> dependencies, BundleType type, Path entry) throws IOException {
        Path path = this.getPath(dependencies, type, entry);
        Path dist = path.resolve("dist");
        Config config = new ConfigBuilder().bundle().minify().sourceMap().splitting().format(Config.Format.ESM).outDir(dist.toString()).entryPoint(path.resolve(entry.getFileName()).toFile().toString()).build();
        this.esBuild(config);
        return dist;
    }

    public Path bundle(List<Path> dependencies, BundleType type, Path entry, Config config) throws IOException {
        Path path = this.extract(dependencies, type);
        config.setEntryPoint(path.resolve(entry.getFileName()).toFile().toString());
        this.esBuild(config);
        return path;
    }

    private Path getPath(List<Path> dependencies, BundleType type, Path entry) throws IOException {
        Path path = this.extract(dependencies, type);
        Path target = path.resolve(entry.getFileName());
        Files.copy(entry, target, StandardCopyOption.REPLACE_EXISTING);
        return path;
    }

    protected Path extract(List<Path> dependencies, BundleType type) throws IOException {
        Path bundleDirectory = Files.createTempDirectory("bundle", new FileAttribute[0]);
        Path nodeModules = bundleDirectory.resolve("node_modules");
        nodeModules.toFile().mkdir();
        for (Path path : dependencies) {
            UnZip.unzip(path, bundleDirectory);
            NameVersion nameVersion = this.parseName(path.getFileName().toString());
            switch (type) {
                case MVNPM: {
                    this.createPackage(bundleDirectory, nameVersion);
                    break;
                }
                case WEB_JAR: {
                    Files.move(bundleDirectory.resolve(WEBJAR_PACKAGE_PREFIX).resolve(nameVersion.name).resolve(nameVersion.version), nodeModules.resolve(nameVersion.name), new CopyOption[0]);
                }
            }
        }
        return bundleDirectory;
    }

    protected void esBuild(Config config) throws IOException {
        Path esBuildExec = new ExecutableResolver().resolve(ESBUILD_VERSION);
        new Execute(esBuildExec.toFile(), config).execute();
    }

    private NameVersion parseName(String fileName) {
        int separatorIndex = fileName.indexOf("-");
        String name = fileName.substring(0, separatorIndex);
        String version = fileName.substring(separatorIndex + 1, fileName.lastIndexOf(46));
        return new NameVersion(name, version);
    }

    private void createPackage(Path location, NameVersion nameVersion) throws IOException {
        String name = nameVersion.name;
        Path importPackage = location.resolve(IMPORT_FILE_NAME);
        String packageContents = ImportToPackage.createPackage(importPackage, name, nameVersion.version);
        Path packageFile = importPackage.getParent().resolve(MVNPM_PACKAGE_PREFIX).resolve(name).resolve("package.json");
        Files.writeString(packageFile, (CharSequence)packageContents, new OpenOption[0]);
        Files.move(packageFile.getParent(), location.resolve("node_modules").resolve(name), new CopyOption[0]);
    }

    static enum BundleType {
        WEB_JAR,
        MVNPM;

    }

    static class NameVersion {
        public String name;
        public String version;

        public NameVersion(String name, String version) {
            this.name = name;
            this.version = version;
        }
    }
}

