/*
 * Decompiled with CFR 0.152.
 */
package ch.nerdin.esbuild.util;

import io.quarkus.qute.Engine;
import io.quarkus.qute.Template;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import org.json.JSONObject;
import org.json.JSONTokener;

public class ImportToPackage {
    protected static String convert(String name, String version, String main) {
        List<String> template;
        Engine engine = Engine.builder().addDefaults().build();
        URL location = ImportToPackage.class.getResource("/package-template.json");
        try {
            template = Files.readAllLines(new File(location.toURI()).toPath());
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
        Template packageJson = engine.parse(String.join((CharSequence)"\n", template));
        return packageJson.data("name", (Object)name, "version", (Object)version, "main", (Object)main).render();
    }

    protected static String extractInfo(Path importMapFile, String name) {
        try {
            JSONTokener jsonTokener = new JSONTokener((InputStream)new FileInputStream(importMapFile.toFile()));
            JSONObject object = new JSONObject(jsonTokener);
            return object.getJSONObject("imports").getString(name);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static String createPackage(Path importMapFile, String name, String version) {
        String main = ImportToPackage.extractInfo(importMapFile, name);
        return ImportToPackage.convert(name, version, main.substring(main.indexOf(name) + name.length() + 1));
    }
}

