/*
 * Decompiled with CFR 0.152.
 */
package ch.nerdin.esbuild.modal;

import ch.nerdin.esbuild.modal.Entry;
import ch.nerdin.esbuild.util.QuteTemplateRenderer;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BundleEntry
extends Entry {
    private static final Set<String> SCRIPTS = Set.of("js", "ts", "jsx", "tsx");
    private final String name;
    private final List<Path> scripts;

    public BundleEntry(String name, List<Path> scripts) {
        this.name = name;
        this.scripts = scripts;
    }

    private Path bundleScripts(String bundleName, List<Path> resources, Path location) throws IOException {
        String entryString = this.convert(resources);
        Path entry = location.resolve("%s.js".formatted(bundleName));
        Files.writeString(entry, (CharSequence)entryString, new OpenOption[0]);
        return entry;
    }

    private String convert(List<Path> resources) {
        return QuteTemplateRenderer.render("entrypoint-template.js", Map.of("imports", resources.stream().map(path -> {
            String fileName = path.getFileName().toString();
            int index = fileName.lastIndexOf(".");
            String name = fileName.substring(0, index);
            String ext = fileName.substring(index + 1);
            boolean isScript = SCRIPTS.contains(ext);
            HashMap<String, String> imports = new HashMap<String, String>();
            String pathName = path.toString();
            imports.put("from", isScript ? pathName.substring(0, pathName.lastIndexOf(".")) : path.toString());
            imports.put("as", isScript ? name.replaceAll("-", "") : null);
            return imports;
        })));
    }

    @Override
    public Path process(Path location) {
        try {
            return this.bundleScripts(this.name, this.copyToLocation(location, this.scripts), location);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

