/*
 * Decompiled with CFR 0.152.
 */
package ch.nerdin.esbuild.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.spi.FileSystemProvider;
import java.util.Comparator;
import java.util.stream.Stream;

public class Copy {
    public static void copyFolder(Path src, Path dest) {
        try (Stream<Path> stream = Files.walk(src, new FileVisitOption[0]);){
            stream.forEach(source -> Copy.copy(source, dest.resolve(src.relativize((Path)source))));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void copy(Path source, Path dest) {
        try {
            Files.copy(source, dest, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void deleteRecursive(Path source) throws IOException {
        try (Stream<Path> paths = Files.walk(source, new FileVisitOption[0]);){
            paths.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
        }
    }

    public static void smartMove(Path source, Path dest) throws IOException {
        FileSystemProvider providerDest;
        FileSystemProvider providerSrc = source.getFileSystem().provider();
        if (providerSrc == (providerDest = source.getFileSystem().provider())) {
            Files.move(source, dest, new CopyOption[0]);
        } else {
            Copy.copyFolder(source, dest);
            Copy.deleteRecursive(source);
        }
    }
}

