/*
 * Decompiled with CFR 0.152.
 */
package ch.nerdin.esbuild.util;

import ch.nerdin.esbuild.util.Copy;
import ch.nerdin.esbuild.util.QuteTemplateRenderer;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.json.JSONObject;
import org.json.JSONTokener;

public class ImportToPackage {
    private static final String MVNPM_PACKAGE_PREFIX = "resources";
    private static final String IMPORT_FILE_NAME = "META-INF/importmap.json";

    protected static String convert(String name, String version, String main) {
        return QuteTemplateRenderer.render("package-template.json", Map.of("name", name, "version", version, "main", main));
    }

    protected static List<PackageInfo> extractPackages(Path importMapFile) {
        try {
            JSONTokener jsonTokener = new JSONTokener((InputStream)new FileInputStream(importMapFile.toFile()));
            JSONObject object = new JSONObject(jsonTokener);
            JSONObject imports = object.getJSONObject("imports");
            Iterator keys = imports.keys();
            ArrayList<PackageInfo> packages = new ArrayList<PackageInfo>();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                String value = imports.getString(key);
                if (!value.endsWith(".js") && (!value.endsWith(".mjs") || !imports.has(key + "/"))) continue;
                String dir = (value.endsWith("index.js") || value.endsWith(".mjs")) && !ImportToPackage.hasScripts(importMapFile.getParent().resolve(MVNPM_PACKAGE_PREFIX + imports.getString(key + "/"))) ? value.substring(0, value.lastIndexOf("/") + 1) : imports.getString(key + "/");
                packages.add(new PackageInfo(key, value.substring(dir.length()), dir));
            }
            return packages;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean hasScripts(Path dir) throws IOException {
        try (Stream<Path> list = Files.list(dir);){
            boolean bl = list.map(Path::getFileName).map(Path::toString).anyMatch(n -> n.endsWith(".js") || n.endsWith(".mjs") || n.endsWith(".css"));
            return bl;
        }
    }

    public static void createPackage(Path nodeModules, Path location, String version) throws IOException {
        Path importMapFile = location.resolve(IMPORT_FILE_NAME);
        if (!Files.isRegularFile(importMapFile, new LinkOption[0])) {
            return;
        }
        List<PackageInfo> packages = ImportToPackage.extractPackages(importMapFile);
        for (PackageInfo info : packages) {
            String packageContents = ImportToPackage.convert(info.getName(), version, info.getMain());
            Path packageDir = importMapFile.getParent().resolve(MVNPM_PACKAGE_PREFIX + info.getDirectory()).normalize();
            if (!Files.isDirectory(packageDir, new LinkOption[0])) {
                throw new IllegalStateException("Invalid MVNPM dependency structure: " + packageDir);
            }
            Path packageFile = packageDir.resolve("package.json");
            Files.writeString(packageFile, (CharSequence)packageContents, new OpenOption[0]);
            Path targetDir = nodeModules.resolve(info.getName()).normalize();
            if (!Files.exists(targetDir.getParent(), new LinkOption[0])) {
                Files.createDirectories(targetDir.getParent(), new FileAttribute[0]);
            }
            Copy.smartMove(packageDir, targetDir);
        }
    }

    static class PackageInfo {
        private final String name;
        private final String main;
        private final String directory;

        PackageInfo(String name, String main, String directory) {
            this.name = name;
            this.main = main;
            this.directory = directory;
        }

        public String getName() {
            return this.name;
        }

        public String getMain() {
            return this.main;
        }

        public String getDirectory() {
            return this.directory;
        }
    }
}

