/*
 * Decompiled with CFR 0.152.
 */
package ch.nerdin.esbuild.resolve;

import ch.nerdin.esbuild.resolve.Resolver;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.rauschig.jarchivelib.Archiver;
import org.rauschig.jarchivelib.ArchiverFactory;

public abstract class BaseResolver {
    public static final String EXECUTABLE_PATH = "package/bin/esbuild";
    protected Resolver resolver;

    public BaseResolver(Resolver resolver) {
        this.resolver = resolver;
    }

    String determineClassifier() {
        String osName = System.getProperty("os.name").toLowerCase();
        String osArch = System.getProperty("os.arch").toLowerCase();
        String classifier = osName.contains("mac") ? (osArch.equals("aarch64") || osArch.contains("arm") ? "darwin-arm64" : "darwin-x64") : (osName.contains("win") ? (osArch.contains("64") ? "win32-x64" : "win32-ia32") : (osArch.equals("aarch64") || osArch.equals("arm64") ? "linux-arm64" : (osArch.contains("arm") ? "linux-arm" : (osArch.contains("64") ? "linux-x64" : "linux-ia32"))));
        return classifier;
    }

    Path extract(InputStream archive, String version) throws IOException {
        File destination = this.createDestination(version).toFile();
        return this.extract(archive, destination);
    }

    Path extract(InputStream archive, File destination) throws IOException {
        Archiver archiver = ArchiverFactory.createArchiver((String)"tar", (String)"gz");
        archiver.extract(archive, destination);
        return destination.toPath().resolve(EXECUTABLE_PATH);
    }

    Path createDestination(String version) throws IOException {
        return Files.createDirectory(this.getLocation(version), new FileAttribute[0]);
    }

    Path getLocation(String version) {
        return Path.of(System.getProperty("java.io.tmpdir"), new String[0]).resolve("esbuild-" + version);
    }
}

