/*
 * Decompiled with CFR 0.152.
 */
package ch.nerdin.esbuild.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Comparator;
import java.util.stream.Stream;

public class Copy {
    public static void copy(Path source, Path dest) {
        try {
            Files.copy(source, dest, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void deleteRecursive(Path source) throws IOException {
        if (!Files.exists(source, new LinkOption[0])) {
            return;
        }
        try (Stream<Path> paths = Files.walk(source, new FileVisitOption[0]);){
            paths.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
        }
    }
}

