/*
 * Decompiled with CFR 0.152.
 */
package ch.nerdin.esbuild.util;

import ch.nerdin.esbuild.util.QuteTemplateRenderer;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Map;
import org.json.JSONObject;
import org.json.JSONTokener;

public class ImportToPackage {
    protected static String convert(String name, String version, String main) {
        return QuteTemplateRenderer.render("package-template.json", Map.of("name", name, "version", version, "main", main));
    }

    protected static String extractInfo(Path importMapFile, String name) {
        try {
            JSONTokener jsonTokener = new JSONTokener((InputStream)new FileInputStream(importMapFile.toFile()));
            JSONObject object = new JSONObject(jsonTokener);
            return object.getJSONObject("imports").getString(name);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static String createPackage(Path importMapFile, String name, String version) {
        String main = ImportToPackage.extractInfo(importMapFile, name);
        return ImportToPackage.convert(name, version, main.substring(main.indexOf(name) + name.length() + 1));
    }
}

