/*
 * Decompiled with CFR 0.152.
 */
package ch.nerdin.esbuild;

import ch.nerdin.esbuild.Config;
import ch.nerdin.esbuild.ConfigBuilder;
import ch.nerdin.esbuild.Execute;
import ch.nerdin.esbuild.resolve.ExecutableResolver;
import ch.nerdin.esbuild.util.EntryPoint;
import ch.nerdin.esbuild.util.ImportToPackage;
import ch.nerdin.esbuild.util.UnZip;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.stream.Collectors;

public class Bundler {
    private static final String IMPORT_FILE_NAME = "META-INF/importmap.json";
    private static final String MVNPM_PACKAGE_PREFIX = "resources/_static";
    private static final String WEBJAR_PACKAGE_PREFIX = "META-INF/resources/webjars";
    public static final String ESBUILD_VERSION = "0.17.10";

    public static Path bundle(List<Path> dependencies, BundleType type, Path entry) throws IOException {
        return Bundler.bundle(dependencies, type, List.of(entry));
    }

    public static Path bundle(List<Path> dependencies, BundleType type, List<Path> entries) throws IOException {
        return Bundler.bundle(dependencies, type, entries, Bundler.useDefaultConfig());
    }

    public static Path bundle(List<Path> dependencies, BundleType type, Path entry, Config config) throws IOException {
        return Bundler.bundle(dependencies, type, List.of(entry), config);
    }

    public static Path bundle(List<Path> dependencies, BundleType type, List<Path> entries, Config config) throws IOException {
        Path location = Bundler.createWorkingTempFolder(dependencies, type, entries);
        Path dist = location.resolve("dist");
        Path entry = Bundler.createOneEntryPointScript(entries, location);
        config.setOutDir(dist.toString());
        config.setEntryPoint(entry.toFile().toString());
        Bundler.esBuild(config);
        return dist;
    }

    private static Path createOneEntryPointScript(List<Path> entries, Path location) throws IOException {
        String entryString = EntryPoint.convert(entries.stream().map(Path::toFile).collect(Collectors.toList()));
        Path entry = location.resolve("index.js");
        Files.writeString(entry, (CharSequence)entryString, new OpenOption[0]);
        return entry;
    }

    private static Config useDefaultConfig() {
        return new ConfigBuilder().bundle().minify().sourceMap().splitting().format(Config.Format.ESM).build();
    }

    private static Path createWorkingTempFolder(List<Path> dependencies, BundleType type, List<Path> entries) throws IOException {
        Path location = Bundler.extract(dependencies, type);
        for (Path entry : entries) {
            Bundler.copy(entry, location);
        }
        return location;
    }

    private static void copy(Path entry, Path location) throws IOException {
        Path target = location.resolve(entry.getFileName());
        Files.copy(entry, target, StandardCopyOption.REPLACE_EXISTING);
    }

    protected static Path extract(List<Path> dependencies, BundleType type) throws IOException {
        Path bundleDirectory = Files.createTempDirectory("bundle", new FileAttribute[0]);
        Path nodeModules = bundleDirectory.resolve("node_modules");
        nodeModules.toFile().mkdir();
        for (Path path : dependencies) {
            UnZip.unzip(path, bundleDirectory);
            NameVersion nameVersion = Bundler.parseName(path.getFileName().toString());
            switch (type) {
                case MVNPM: {
                    Bundler.createPackage(bundleDirectory, nameVersion);
                    break;
                }
                case WEBJARS: {
                    Files.move(bundleDirectory.resolve(WEBJAR_PACKAGE_PREFIX).resolve(nameVersion.name).resolve(nameVersion.version), nodeModules.resolve(nameVersion.name), new CopyOption[0]);
                }
            }
        }
        return bundleDirectory;
    }

    protected static void esBuild(Config config) throws IOException {
        Path esBuildExec = new ExecutableResolver().resolve(ESBUILD_VERSION);
        new Execute(esBuildExec.toFile(), config).execute();
    }

    private static NameVersion parseName(String fileName) {
        int separatorIndex = fileName.indexOf("-");
        String name = fileName.substring(0, separatorIndex);
        String version = fileName.substring(separatorIndex + 1, fileName.lastIndexOf(46));
        return new NameVersion(name, version);
    }

    private static void createPackage(Path location, NameVersion nameVersion) throws IOException {
        String name = nameVersion.name;
        Path importPackage = location.resolve(IMPORT_FILE_NAME);
        String packageContents = ImportToPackage.createPackage(importPackage, name, nameVersion.version);
        Path packageFile = importPackage.getParent().resolve(MVNPM_PACKAGE_PREFIX).resolve(name).resolve("package.json");
        Files.writeString(packageFile, (CharSequence)packageContents, new OpenOption[0]);
        Files.move(packageFile.getParent(), location.resolve("node_modules").resolve(name), new CopyOption[0]);
    }

    public static enum BundleType {
        WEBJARS,
        MVNPM;

    }

    static class NameVersion {
        public String name;
        public String version;

        public NameVersion(String name, String version) {
            this.name = name;
            this.version = version;
        }
    }
}

