/*
 * Decompiled with CFR 0.152.
 */
package ch.nerdin.esbuild.util;

import ch.nerdin.esbuild.util.QuteTemplateRenderer;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONObject;
import org.json.JSONTokener;

public class ImportToPackage {
    protected static String convert(String name, String version, String main) {
        return QuteTemplateRenderer.render("package-template.json", Map.of("name", name, "version", version, "main", main));
    }

    protected static String extractInfo(Path importMapFile) {
        try {
            JSONTokener jsonTokener = new JSONTokener((InputStream)new FileInputStream(importMapFile.toFile()));
            JSONObject object = new JSONObject(jsonTokener);
            JSONObject imports = object.getJSONObject("imports");
            Iterator keys = imports.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                String importsString = imports.getString(key);
                if (!importsString.contains(".js")) continue;
                return importsString;
            }
            throw new RuntimeException("could not find script in import map");
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static String createPackage(Path importMapFile, String name, String version) {
        String main = ImportToPackage.extractInfo(importMapFile);
        return ImportToPackage.convert(name, version, main.substring(main.indexOf(name) + name.length() + 1));
    }
}

