/*
 * Decompiled with CFR 0.152.
 */
package ch.nerdin.esbuild;

import ch.nerdin.esbuild.BundleOptions;
import ch.nerdin.esbuild.Bundler;
import ch.nerdin.esbuild.EsBuildConfig;
import ch.nerdin.esbuild.EsBuildConfigBuilder;
import java.nio.file.Path;
import java.util.List;

public class BundleOptionsBuilder {
    private String bundleName = "bundle";
    private List<Path> dependencies;
    private Bundler.BundleType type;
    private List<Path> entries;
    private EsBuildConfig esBuildConfig = BundleOptionsBuilder.useDefaultConfig();

    private static EsBuildConfig useDefaultConfig() {
        return new EsBuildConfigBuilder().bundle().minify().sourceMap().splitting().format(EsBuildConfig.Format.ESM).build();
    }

    public BundleOptionsBuilder withBundleName(String bundleName) {
        this.bundleName = bundleName;
        return this;
    }

    public BundleOptionsBuilder withDependencies(List<Path> dependencies) {
        this.dependencies = dependencies;
        return this;
    }

    public BundleOptionsBuilder withType(Bundler.BundleType type) {
        this.type = type;
        return this;
    }

    public BundleOptionsBuilder withEntries(List<Path> entries) {
        this.entries = entries;
        return this;
    }

    public BundleOptionsBuilder withEntry(Path entry) {
        this.entries = List.of(entry);
        return this;
    }

    public BundleOptions build() {
        BundleOptions options = new BundleOptions();
        options.setBundleName(this.bundleName);
        options.setDependencies(this.dependencies);
        options.setType(this.type);
        options.setEntries(this.entries);
        options.setEsBuildConfig(this.esBuildConfig);
        return options;
    }
}

