/*
 * Decompiled with CFR 0.152.
 */
package ch.nerdin.esbuild;

import ch.nerdin.esbuild.BuildEventListener;
import ch.nerdin.esbuild.BundleException;
import ch.nerdin.esbuild.modal.EsBuildConfig;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Execute {
    private static final Logger logger = LoggerFactory.getLogger(Execute.class);
    private final File esBuildExec;
    private EsBuildConfig esBuildConfig;
    private String[] args;
    private Process process;

    public Execute(File esBuildExec, EsBuildConfig esBuildConfig) {
        this.esBuildExec = esBuildExec;
        this.esBuildConfig = esBuildConfig;
    }

    public Execute(File esBuildExec, String[] args) {
        this.esBuildExec = esBuildExec;
        this.args = args;
    }

    public void executeAndWait() throws IOException {
        String[] command = this.args != null ? this.getCommand(this.args) : this.getCommand(this.esBuildConfig);
        this.watchOutput(command, () -> {});
        try {
            this.process.waitFor();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public Process execute(BuildEventListener listener) throws IOException {
        String[] command = this.args != null ? this.getCommand(this.args) : this.getCommand(this.esBuildConfig);
        this.watchOutput(command, listener);
        return this.process;
    }

    private String[] getCommand(EsBuildConfig esBuildConfig) {
        String[] params = esBuildConfig.toParams();
        return this.getCommand(params);
    }

    private String[] getCommand(String[] args) {
        ArrayList<String> argList = new ArrayList<String>(args.length + 1);
        argList.add(this.esBuildExec.toString());
        argList.addAll(Arrays.asList(args));
        return argList.toArray(new String[0]);
    }

    public void watchOutput(String[] command, BuildEventListener listener) throws IOException {
        this.process = new ProcessBuilder(new String[0]).command(command).start();
        InputStream errorStream = this.process.getErrorStream();
        Thread t = new Thread(new Streamer(errorStream, listener));
        t.setName("Process stdout streamer");
        t.setDaemon(true);
        t.start();
    }

    private record Streamer(InputStream processStream, BuildEventListener listener) implements Runnable
    {
        @Override
        public void run() {
            StringBuilder error = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.processStream, StandardCharsets.UTF_8));){
                String line;
                while ((line = reader.readLine()) != null) {
                    logger.debug(line);
                    if (line.contains("\u2718 [ERROR]") || !error.isEmpty()) {
                        error.append(line);
                        continue;
                    }
                    if (!line.contains("build finished")) continue;
                    logger.info("Build finished!");
                    this.listener.onChange();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!error.isEmpty()) {
                throw new BundleException(error.toString());
            }
        }
    }
}

