/*
 * Decompiled with CFR 0.152.
 */
package ch.nerdin.esbuild.modal;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class EsBuildConfig {
    private boolean bundle;
    private String[] entryPoint;
    private boolean minify;
    private boolean version;
    private Map<String, String> substitutes;
    private List<String> excludes;
    private Format format;
    private Map<String, Loader> loader;
    private String outDir;
    private String packages;
    private Platform platform;
    private boolean serve;
    private boolean sourceMap;
    private boolean splitting;
    private Target target;
    private boolean watch;

    public boolean isBundle() {
        return this.bundle;
    }

    public void setBundle(boolean bundle) {
        this.bundle = bundle;
    }

    public String[] getEntryPoint() {
        return this.entryPoint;
    }

    public void setEntryPoint(String[] entryPoint) {
        this.entryPoint = entryPoint;
    }

    public boolean isMinify() {
        return this.minify;
    }

    public void setMinify(boolean minify) {
        this.minify = minify;
    }

    public boolean isVersion() {
        return this.version;
    }

    public void setVersion(boolean version) {
        this.version = version;
    }

    public Map<String, String> getSubstitutes() {
        return this.substitutes;
    }

    public void setSubstitutes(Map<String, String> substitutes) {
        this.substitutes = substitutes;
    }

    public List<String> getExcludes() {
        return this.excludes;
    }

    public void setExcludes(List<String> excludes) {
        this.excludes = excludes;
    }

    public Format getFormat() {
        return this.format;
    }

    public void setFormat(Format format) {
        this.format = format;
    }

    public Map<String, Loader> getLoader() {
        return this.loader;
    }

    public void setLoader(Map<String, Loader> loader) {
        this.loader = loader;
    }

    public String getOutDir() {
        return this.outDir;
    }

    public void setOutDir(String outDir) {
        this.outDir = outDir;
    }

    public String getPackages() {
        return this.packages;
    }

    public void setPackages(String packages) {
        this.packages = packages;
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public void setPlatform(Platform platform) {
        this.platform = platform;
    }

    public boolean isServe() {
        return this.serve;
    }

    public void setServe(boolean serve) {
        this.serve = serve;
    }

    public boolean isSourceMap() {
        return this.sourceMap;
    }

    public void setSourceMap(boolean sourceMap) {
        this.sourceMap = sourceMap;
    }

    public boolean isSplitting() {
        return this.splitting;
    }

    public void setSplitting(boolean splitting) {
        this.splitting = splitting;
    }

    public Target getTarget() {
        return this.target;
    }

    public void setTarget(Target target) {
        this.target = target;
    }

    public boolean isWatch() {
        return this.watch;
    }

    public void setWatch(boolean watch) {
        this.watch = watch;
    }

    public String[] toParams() {
        Field[] fields = EsBuildConfig.class.getDeclaredFields();
        ArrayList<Object> result = new ArrayList<Object>(fields.length);
        for (Field field : fields) {
            field.setAccessible(true);
            try {
                Object value = field.get(this);
                if (value == null) continue;
                String fieldName = field.getName();
                if (value == Boolean.TRUE) {
                    result.add("--" + fieldName.toLowerCase());
                    continue;
                }
                if (value instanceof Map) {
                    result.addAll(EsBuildConfig.mapToString(fieldName, (Map)value));
                    continue;
                }
                if ("entryPoint".equals(field.getName())) {
                    result.addAll(List.of((String[])value));
                    continue;
                }
                if (value instanceof Boolean) continue;
                result.add("--%s=%s".formatted(fieldName.toLowerCase(), value.toString().toLowerCase()));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return (String[])result.toArray(String[]::new);
    }

    private static List<String> mapToString(String fieldName, Map<?, ?> map) {
        ArrayList<String> result = new ArrayList<String>(map.size());
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            result.add("--%s:%s=%s".formatted(fieldName, entry.getKey(), entry.getValue().toString().toLowerCase()));
        }
        return result;
    }

    static enum Format {
        IIFE,
        CJS,
        ESM;

    }

    static enum Platform {
        BROWSER,
        NODE,
        NEUTRAL;

    }

    static enum Target {
        ES2017,
        CHROME58,
        FIREFOX57,
        SAFARI11,
        EDGE16,
        NODE10,
        IE9,
        OPERA45;

    }

    static enum Loader {
        BASE64,
        BINARY,
        COPY,
        CSS,
        DATAURL,
        EMPTY,
        FILE,
        JS,
        JSON,
        JSX,
        TEXT,
        TS,
        TSX;

    }
}

