/*
 * Decompiled with CFR 0.152.
 */
package ch.nerdin.esbuild;

import ch.nerdin.esbuild.BuildEventListener;
import ch.nerdin.esbuild.Execute;
import ch.nerdin.esbuild.Watch;
import ch.nerdin.esbuild.modal.BundleOptions;
import ch.nerdin.esbuild.modal.EsBuildConfig;
import ch.nerdin.esbuild.resolve.ExecutableResolver;
import ch.nerdin.esbuild.util.ImportToPackage;
import ch.nerdin.esbuild.util.UnZip;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Properties;

public class Bundler {
    private static final String WEBJAR_PACKAGE_PREFIX = "META-INF/resources/webjars";
    private static String VERSION;

    public static String getDefaultVersion() {
        if (VERSION == null) {
            InputStream resource = Bundler.class.getResourceAsStream("/version.properties");
            Properties properties = new Properties();
            try {
                properties.load(resource);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            VERSION = properties.getProperty("esbuild.version", "0.17.17");
        }
        return VERSION;
    }

    public static Path bundle(BundleOptions bundleOptions) throws IOException {
        Path location = Bundler.createWorkingTempFolder(bundleOptions.getDependencies(), bundleOptions.getType());
        Path dist = location.resolve("dist");
        EsBuildConfig esBuildConfig = Bundler.createBundle(bundleOptions, location, dist);
        Bundler.esBuild(esBuildConfig, null);
        return dist;
    }

    private static EsBuildConfig createBundle(BundleOptions bundleOptions, Path location, Path dist) {
        EsBuildConfig esBuildConfig = bundleOptions.getEsBuildConfig();
        esBuildConfig.setOutDir(dist.toString());
        List<String> paths = bundleOptions.getEntries().stream().map(entry -> entry.getEntry(location).toString()).toList();
        esBuildConfig.setEntryPoint(paths.toArray(new String[0]));
        return esBuildConfig;
    }

    public static Watch watch(BundleOptions bundleOptions, BuildEventListener eventListener) throws IOException {
        Path location = Bundler.createWorkingTempFolder(bundleOptions.getDependencies(), bundleOptions.getType());
        Path dist = location.resolve("dist");
        EsBuildConfig esBuildConfig = Bundler.createBundle(bundleOptions, location, dist);
        bundleOptions.getEsBuildConfig().setWatch(true);
        Process process = Bundler.esBuild(esBuildConfig, eventListener);
        return new Watch(process, location, bundleOptions.getType());
    }

    private static Path createWorkingTempFolder(List<Path> dependencies, BundleType type) throws IOException {
        Path bundleDirectory = Files.createTempDirectory("bundle", new FileAttribute[0]);
        return Bundler.extract(bundleDirectory, dependencies, type);
    }

    protected static Path extract(Path bundleDirectory, List<Path> dependencies, BundleType type) throws IOException {
        Path nodeModules = bundleDirectory.resolve("node_modules");
        if (!Files.exists(nodeModules, new LinkOption[0])) {
            nodeModules.toFile().mkdir();
        }
        for (Path path : dependencies) {
            NameVersion nameVersion = Bundler.parseName(path.getFileName().toString());
            Path temp = Files.createTempDirectory(nameVersion.toString(), new FileAttribute[0]);
            UnZip.unzip(path, temp);
            switch (type) {
                case MVNPM: {
                    ImportToPackage.createPackage(nodeModules, temp, nameVersion.name, nameVersion.version);
                    break;
                }
                case WEBJARS: {
                    Files.move(temp.resolve(WEBJAR_PACKAGE_PREFIX).resolve(nameVersion.name).resolve(nameVersion.version), nodeModules.resolve(nameVersion.name), new CopyOption[0]);
                }
            }
        }
        return bundleDirectory;
    }

    protected static Process esBuild(EsBuildConfig esBuildConfig, BuildEventListener listener) throws IOException {
        Path esBuildExec = new ExecutableResolver().resolve(Bundler.getDefaultVersion());
        Execute execute = new Execute(esBuildExec.toFile(), esBuildConfig);
        if (listener != null) {
            return execute.execute(listener);
        }
        execute.executeAndWait();
        return null;
    }

    private static NameVersion parseName(String fileName) {
        int separatorIndex = fileName.lastIndexOf("-");
        String name = fileName.substring(0, separatorIndex);
        String version = fileName.substring(separatorIndex + 1, fileName.lastIndexOf(46));
        return new NameVersion(name, version);
    }

    public static enum BundleType {
        WEBJARS,
        MVNPM;

    }

    static class NameVersion {
        public String name;
        public String version;

        public NameVersion(String name, String version) {
            this.name = name;
            this.version = version;
        }

        public String toString() {
            return this.name + "-" + this.version;
        }
    }
}

