/*
 * Decompiled with CFR 0.152.
 */
package ch.nerdin.esbuild.modal;

import ch.nerdin.esbuild.Bundler;
import ch.nerdin.esbuild.modal.BundleEntry;
import ch.nerdin.esbuild.modal.BundleOptions;
import ch.nerdin.esbuild.modal.Entry;
import ch.nerdin.esbuild.modal.EsBuildConfig;
import ch.nerdin.esbuild.modal.EsBuildConfigBuilder;
import ch.nerdin.esbuild.modal.FileEntry;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public class BundleOptionsBuilder {
    private BundleOptions options = new BundleOptions();

    public BundleOptionsBuilder() {
        this.options.setEsBuildConfig(BundleOptionsBuilder.useDefaultConfig());
    }

    private static EsBuildConfig useDefaultConfig() {
        return new EsBuildConfigBuilder().build();
    }

    public BundleOptionsBuilder addEntryPoint(String name, List<Path> scripts) {
        return this.addEntryPoint(new BundleEntry(name, scripts));
    }

    public BundleOptionsBuilder addEntryPoint(Path script) {
        this.addEntryPoint(new FileEntry(script));
        return this;
    }

    protected BundleOptionsBuilder addEntryPoint(Entry entry) {
        if (this.options.getEntries() == null) {
            this.options.setEntries(new ArrayList<Entry>());
        }
        this.options.getEntries().add(entry);
        return this;
    }

    public BundleOptionsBuilder withDependencies(List<Path> dependencies) {
        this.options.setDependencies(dependencies);
        return this;
    }

    public BundleOptionsBuilder withType(Bundler.BundleType type) {
        this.options.setType(type);
        return this;
    }

    public BundleOptionsBuilder withEsConfig(EsBuildConfig esBuildConfig) {
        this.options.setEsBuildConfig(esBuildConfig);
        return this;
    }

    public BundleOptions build() {
        return this.options;
    }
}

