/*
 * Decompiled with CFR 0.152.
 */
package ch.netcetera.eclipse.common.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.zip.GZIPInputStream;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public abstract class AbstractHttpClient {
    protected static final int DEFAULT_BUFFER_SIZE = 8192;
    private IProxyService proxyService;

    protected <R> R executeGetRequest(String url, IResponseHandler<R> handler, IProgressMonitor monitor) throws CoreException {
        DefaultHttpClient client = new DefaultHttpClient();
        HttpGet get = new HttpGet(url);
        get.addHeader("Accept-Encoding", "gzip");
        this.configureProxySettings((HttpClient)client, get);
        this.configureSslHandling((HttpClient)client);
        try {
            HttpResponse response = client.execute((HttpUriRequest)get);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                return handler.handleResponse(response, monitor);
            }
            throw this.convertHttpStatusToException(statusCode, get.getURI());
        }
        catch (IOException e) {
            throw this.wrapIoException(e);
        }
    }

    private void configureProxySettings(HttpClient client, HttpGet get) {
        if (this.getProxyService() != null && this.getProxyService().getProxyData() != null && this.getProxyService().getProxyData().length > 0) {
            String requestScheme = get.getURI().getScheme();
            IProxyData[] iProxyDataArray = this.getProxyService().getProxyData();
            int n = iProxyDataArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProxyData proxyData = iProxyDataArray[n2];
                if (proxyData != null && proxyData.getHost() != null && proxyData.getType().equalsIgnoreCase(requestScheme)) {
                    HttpHost proxy = new HttpHost(proxyData.getHost(), proxyData.getPort(), requestScheme);
                    client.getParams().setParameter("http.route.default-proxy", (Object)proxy);
                    break;
                }
                ++n2;
            }
        }
    }

    private void configureSslHandling(HttpClient httpClient) throws CoreException {
        Scheme http = new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory());
        Scheme https = new Scheme("https", 443, (SchemeSocketFactory)SSLSocketFactory.getSocketFactory());
        SchemeRegistry sr = httpClient.getConnectionManager().getSchemeRegistry();
        sr.register(http);
        sr.register(https);
    }

    private CoreException wrapIoException(IOException e) {
        return this.wrapGenericException(e);
    }

    private CoreException wrapGenericException(Exception e) {
        Status status = new Status(4, this.getBundleSymbolicName(), e.getLocalizedMessage(), (Throwable)e);
        return new CoreException((IStatus)status);
    }

    protected abstract String getBundleSymbolicName();

    private CoreException convertHttpStatusToException(int httpStatusCode, URI uri) {
        Status status = new Status(2, this.getBundleSymbolicName(), "ETE received an unexpected HTTP status code " + httpStatusCode + " while connecting to " + uri);
        return new CoreException((IStatus)status);
    }

    protected static void copy(InputStream input, OutputStream output) throws IOException, NullPointerException {
        byte[] buffer = new byte[8192];
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
        }
    }

    protected InputStream wrapResponseStream(HttpResponse response, InputStream stream, IProgressMonitor monitor) throws IOException {
        InputStream input = stream;
        Header contentEncoding = response.getFirstHeader("Content-Encoding");
        long contentLength = response.getEntity().getContentLength();
        if (contentLength != -1L) {
            monitor.beginTask("Parsing Response", (int)contentLength);
            input = new ProgressReportingInputStream(input, monitor);
        }
        if (contentEncoding != null && "gzip".equalsIgnoreCase(contentEncoding.getValue())) {
            input = new GZIPInputStream(input);
        }
        return input;
    }

    public void bindProxyService(IProxyService proxyService) {
        this.proxyService = proxyService;
    }

    public void unbindProxyService(IProxyService proxyService) {
        this.proxyService = null;
    }

    protected IProxyService getProxyService() {
        return this.proxyService;
    }

    public static interface IResponseHandler<R> {
        public R handleResponse(HttpResponse var1, IProgressMonitor var2) throws IOException;
    }

    protected static final class ProgressReportingInputStream
    extends InputStream {
        private final InputStream stream;
        private final IProgressMonitor monitor;

        ProgressReportingInputStream(InputStream stream, IProgressMonitor monitor) {
            this.stream = stream;
            this.monitor = monitor;
        }

        @Override
        public int available() throws IOException {
            return this.stream.available();
        }

        @Override
        public void close() throws IOException {
            try {
                this.stream.close();
            }
            finally {
                this.monitor.done();
            }
        }

        @Override
        public void mark(int readlimit) {
            this.stream.mark(readlimit);
        }

        @Override
        public boolean markSupported() {
            return this.stream.markSupported();
        }

        @Override
        public int read() throws IOException {
            int data = this.stream.read();
            this.monitor.worked(1);
            return data;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int read = this.stream.read(b, off, len);
            this.monitor.worked(read);
            return read;
        }

        @Override
        public int read(byte[] b) throws IOException {
            int read = this.stream.read(b);
            this.monitor.worked(read);
            return read;
        }

        @Override
        public void reset() throws IOException {
            this.stream.reset();
        }

        @Override
        public long skip(long n) throws IOException {
            long skipped = this.stream.skip(n);
            this.monitor.worked((int)skipped);
            return skipped;
        }
    }
}

