/*
 * Decompiled with CFR 0.152.
 */
package ch.netcetera.eclipse.common.security;

import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;

public final class SecurePreferencesUtil {
    private SecurePreferencesUtil() {
        throw new AssertionError((Object)"not instantiable");
    }

    public static void store(String nodePathName, String key, String value) throws StorageException {
        SecurePreferencesUtil.getNode(nodePathName).put(key, value, true);
    }

    public static void storeSilently(String nodePathName, String key, String value) {
        try {
            SecurePreferencesUtil.store(nodePathName, key, value);
        }
        catch (StorageException storageException) {}
    }

    public static String get(String nodePathName, String key) throws StorageException {
        return SecurePreferencesUtil.getNode(nodePathName).get(key, "");
    }

    public static String getSilentlyWithDefault(String nodePathName, String key, String defaultValue) {
        try {
            return SecurePreferencesUtil.getNode(nodePathName).get(key, defaultValue);
        }
        catch (StorageException storageException) {
            return defaultValue;
        }
    }

    public static void removeSilently(String nodePathName, String key) {
        try {
            SecurePreferencesUtil.getNode(nodePathName).remove(key);
        }
        catch (IllegalStateException illegalStateException) {}
    }

    private static ISecurePreferences getNode(String nodePathName) {
        return SecurePreferencesFactory.getDefault().node(nodePathName);
    }
}

