/*
 * Decompiled with CFR 0.152.
 */
package ch.netcetera.eclipse.projectconfig.core.configurationcommands;

import ch.netcetera.eclipse.common.text.ITextAccessor;
import ch.netcetera.eclipse.projectconfig.core.configurationcommands.AbstractProjectConfigurationCommand;
import java.io.File;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class MkdirProjectConfigurationCommand
extends AbstractProjectConfigurationCommand {
    public static final String COMMAND_NAME = "mkdir";

    public MkdirProjectConfigurationCommand(List<String> argumentList, ITextAccessor textAccessor, String pluginId, ILog log) {
        super(argumentList, textAccessor, pluginId, log);
    }

    @Override
    IStatus executeOnProject(IProject project) {
        IPath pathToDirectory = project.getLocation().append(this.getArgumentList().get(1));
        IStatus status = Status.OK_STATUS;
        File dirFile = pathToDirectory.toFile();
        if (dirFile != null && !dirFile.exists()) {
            try {
                if (!dirFile.mkdirs()) {
                    status = this.createStatus(4, this.getTextAccessor().getText("error.createdir"));
                }
            }
            catch (SecurityException e) {
                status = this.createStatus(4, e.getLocalizedMessage(), e);
            }
        }
        return status;
    }

    @Override
    boolean isEnabled() {
        return this.getArgumentList() != null && this.getArgumentList().size() == 2;
    }
}

