/*
 * Decompiled with CFR 0.152.
 */
package ch.netcetera.eclipse.projectconfig.core.configurationcommands;

import ch.netcetera.eclipse.common.text.ITextAccessor;
import ch.netcetera.eclipse.projectconfig.core.configurationcommands.AbstractNatureProjectConfigurationCommand;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class RemoveNatureProjectConfigurationCommand
extends AbstractNatureProjectConfigurationCommand {
    public static final String COMMAND_NAME = "removenature";

    public RemoveNatureProjectConfigurationCommand(List<String> argumentList, ITextAccessor textAccessor, String pluginId, ILog log) {
        super(argumentList, textAccessor, pluginId, log);
    }

    @Override
    IStatus executeOnProject(IProject project) {
        IStatus status = Status.OK_STATUS;
        try {
            String removeNatureID = this.getArgumentList().get(1);
            if (!this.projectHasNature(project, removeNatureID)) {
                return status;
            }
            IProjectDescription projectDescription = project.getDescription();
            ArrayList<String> natureIDs = new ArrayList<String>(Arrays.asList(projectDescription.getNatureIds()));
            natureIDs.remove(removeNatureID);
            projectDescription.setNatureIds(natureIDs.toArray(new String[natureIDs.size()]));
            project.setDescription(projectDescription, null);
        }
        catch (CoreException e) {
            status = this.createStatus(4, e.getLocalizedMessage(), e);
        }
        return status;
    }
}

