/*
 * Decompiled with CFR 0.152.
 */
package ch.netcetera.eclipse.workspaceconfig.ui;

import ch.netcetera.eclipse.common.text.ITextAccessor;
import ch.netcetera.eclipse.common.validator.UriInputValidator;
import ch.netcetera.eclipse.workspaceconfig.ui.WorkspaceConfigurationUIPlugin;
import ch.netcetera.eclipse.workspaceconfig.ui.preferences.ConfigurationUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class RemotePreferencesImportPage
extends WizardPage {
    private final UriInputValidator uriValidator = new UriInputValidator(Collections.emptyList(), "", (ITextAccessor)WorkspaceConfigurationUIPlugin.getDefault());
    private Text urlText;
    private Table table;
    private ITextAccessor textAccessor = WorkspaceConfigurationUIPlugin.getDefault();
    private TableColumn tableColumn;

    protected RemotePreferencesImportPage() {
        this("remotePreferencesImportPage");
    }

    protected RemotePreferencesImportPage(String pageName) {
        super(pageName);
        this.setTitle(this.textAccessor.getText("import.wizard.title"));
        this.setDescription(this.textAccessor.getText("import.wizard.description"));
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        Button directImportRadioButton = new Button(composite, 16);
        directImportRadioButton.setText(this.textAccessor.getText("import.wizard.fromurl"));
        directImportRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                RemotePreferencesImportPage.this.table.setEnabled(false);
                RemotePreferencesImportPage.this.urlText.setEnabled(true);
                RemotePreferencesImportPage.this.validateUrl();
            }
        });
        this.urlText = new Text(composite, 2048);
        this.urlText.setLayoutData((Object)new GridData(768));
        this.urlText.setEnabled(false);
        this.urlText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                super.keyReleased(e);
                RemotePreferencesImportPage.this.validateUrl();
            }
        });
        Button importConfiguredRadioButton = new Button(composite, 16);
        importConfiguredRadioButton.setText(this.textAccessor.getText("import.wizard.fromlist"));
        importConfiguredRadioButton.setSelection(true);
        importConfiguredRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                RemotePreferencesImportPage.this.table.setEnabled(true);
                RemotePreferencesImportPage.this.urlText.setEnabled(false);
                RemotePreferencesImportPage.this.validateTableSelection();
            }
        });
        this.table = new Table(composite, 2080);
        GridData tgd = new GridData(1808);
        tgd.heightHint = 200;
        this.table.setLayoutData((Object)tgd);
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                RemotePreferencesImportPage.this.validateTableSelection();
            }
        });
        this.tableColumn = new TableColumn(this.table, 16384);
        this.table.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                RemotePreferencesImportPage.this.resiseTableColumnWidth();
            }
        });
        this.loadTableItems();
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        this.calculatePageComplete();
    }

    private void resiseTableColumnWidth() {
        this.tableColumn.setWidth(this.table.getSize().x - 40);
    }

    void validateUrl() {
        String url = this.urlText.getText();
        String message = this.uriValidator.isValid(url);
        this.setErrorMessage(message);
        this.calculatePageComplete();
    }

    void validateTableSelection() {
        this.setErrorMessage(null);
        if (this.getCheckedTableItemsAsString().isEmpty()) {
            this.setErrorMessage(this.textAccessor.getText("import.wizard.error.selectone"));
        }
        this.calculatePageComplete();
    }

    private void calculatePageComplete() {
        boolean urlTextOk = !this.urlText.isEnabled() || !this.urlText.getText().isEmpty();
        boolean hasError = this.getErrorMessage() != null;
        this.setPageComplete(!hasError && urlTextOk);
    }

    private void loadTableItems() {
        for (String url : ConfigurationUtil.getEpfUrls()) {
            TableItem item = new TableItem(this.table, 0);
            item.setText(url);
            item.setChecked(true);
        }
    }

    List<String> getImportUrlList() {
        if (this.urlText.isEnabled()) {
            return Collections.singletonList(this.urlText.getText().trim());
        }
        return this.getCheckedTableItemsAsString();
    }

    boolean doVariableSubstitution() {
        return this.table.isEnabled();
    }

    private List<String> getCheckedTableItemsAsString() {
        ArrayList<String> checkedTableItems = new ArrayList<String>();
        TableItem[] tableItemArray = this.table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem tableItem = tableItemArray[n2];
            if (tableItem.getChecked()) {
                checkedTableItems.add(tableItem.getText());
            }
            ++n2;
        }
        return checkedTableItems;
    }
}

