/*
 * Decompiled with CFR 0.152.
 */
package ch.netcetera.eclipse.workspaceconfig.ui.handler;

import ch.netcetera.eclipse.workspaceconfig.core.IPreferencesImportService;
import ch.netcetera.eclipse.workspaceconfig.ui.WorkspaceConfigurationUIPlugin;
import ch.netcetera.eclipse.workspaceconfig.ui.preferences.ConfigurationUtil;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.FrameworkUtil;

public class ImportWorkspaceConfigurationHandler
extends AbstractHandler {
    static final String COMMAND_ID = "ch.netcetera.eclipse.workspaceconfig.ui.applySettings";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.applySettings();
        return null;
    }

    private void applySettings() {
        String bundleId = FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getSymbolicName();
        IPreferencesImportService service = WorkspaceConfigurationUIPlugin.getDefault().getPreferencesImportService();
        IStatus status = Status.OK_STATUS;
        if (service != null) {
            List<String> urlList = ConfigurationUtil.getEpfUrls();
            List<String> replacementList = ConfigurationUtil.getEnvReplacements();
            for (String url : urlList) {
                status = service.importConfigFile(url, replacementList);
                if (status.isOK()) continue;
                this.logStatus(status);
                status = Status.OK_STATUS;
            }
        } else {
            this.logStatus((IStatus)new Status(4, bundleId, "could not obtain service reference of IPreferencesImportService"));
        }
    }

    private void logStatus(IStatus status) {
        WorkspaceConfigurationUIPlugin.getDefault().getLog().log(status);
    }
}

