/*
 * Decompiled with CFR 0.152.
 */
package ch.netcetera.eclipse.workspaceconfig.ui.handler;

import ch.netcetera.eclipse.common.text.ITextAccessor;
import ch.netcetera.eclipse.workspaceconfig.ui.WorkspaceConfigurationUIPlugin;
import ch.netcetera.eclipse.workspaceconfig.ui.dialog.WorkspacePrefercensRecorderResultDialog;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;

public class WorkspacePreferencesRecorderHandler
extends AbstractHandler {
    private static final String ISO_8859_1 = "ISO-8859-1";
    private static final String EQUAL = "=";
    private static final String EOL = "\n";
    private static final String HASH = "#";
    private static final String AT = "@";
    private final ITextAccessor textAccessor = WorkspaceConfigurationUIPlugin.getDefault();
    private final ILog log = WorkspaceConfigurationUIPlugin.getDefault().getLog();
    private final String bundleId = WorkspaceConfigurationUIPlugin.getDefault().getBundle().getSymbolicName();
    private boolean isRecording = false;
    private Map<String, String> beforeMap = new HashMap<String, String>();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            Command command = event.getCommand();
            if (this.isRecording) {
                this.endRecording();
                command.define(this.textAccessor.getText("recorder.handler.start"), this.textAccessor.getText("recorder.handler.start.description"), command.getCategory());
            } else {
                this.startRecording();
                command.define(this.textAccessor.getText("recorder.handler.stop"), this.textAccessor.getText("recorder.handler.stop.description"), command.getCategory());
            }
        }
        catch (NotDefinedException e) {
            this.logError(e);
        }
        return null;
    }

    private void startRecording() {
        this.isRecording = true;
        this.beforeMap.clear();
        this.beforeMap = this.getPreferencesMap();
    }

    private void endRecording() {
        this.isRecording = false;
        Map<String, String> afterMap = this.getPreferencesMap();
        StringBuilder preferencesDelta = new StringBuilder();
        preferencesDelta.append(this.textAccessor.getText("recorder.result.removed")).append(EOL);
        HashSet<String> removedKeySet = new HashSet<String>(this.beforeMap.keySet());
        removedKeySet.removeAll(afterMap.keySet());
        for (String string : removedKeySet) {
            preferencesDelta.append(string).append(EQUAL).append(this.beforeMap.get(string)).append(EOL);
        }
        preferencesDelta.append(EOL).append(this.textAccessor.getText("recorder.result.added")).append(EOL);
        HashSet<String> addedKeySet = new HashSet<String>(afterMap.keySet());
        addedKeySet.removeAll(this.beforeMap.keySet());
        for (String string : addedKeySet) {
            preferencesDelta.append(string).append(EQUAL).append(afterMap.get(string)).append(EOL);
        }
        preferencesDelta.append(EOL).append(this.textAccessor.getText("recorder.result.changed")).append(EOL);
        HashSet<String> possiblyChangedKeySet = new HashSet<String>(afterMap.keySet());
        possiblyChangedKeySet.retainAll(this.beforeMap.keySet());
        for (String string : possiblyChangedKeySet) {
            String newValue = afterMap.get(string);
            if (this.beforeMap.get(string).equals(newValue)) continue;
            preferencesDelta.append(string).append(EQUAL).append(newValue).append(EOL);
        }
        new WorkspacePrefercensRecorderResultDialog(null, this.textAccessor, preferencesDelta.toString()).open();
    }

    private Map<String, String> getPreferencesMap() {
        String[] split = this.getPreferencesArray();
        HashMap<String, String> prefMap = new HashMap<String, String>(split.length);
        String[] stringArray = split;
        int n = split.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (!string.startsWith(AT) && !string.startsWith(HASH)) {
                String[] keyvalue = string.split(EQUAL, 2);
                prefMap.put(keyvalue[0], keyvalue[1]);
            }
            ++n2;
        }
        return prefMap;
    }

    private String[] getPreferencesArray() {
        IPreferencesService service = Platform.getPreferencesService();
        IEclipsePreferences node = (IEclipsePreferences)service.getRootNode().node("instance");
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            service.exportPreferences(node, (OutputStream)outputStream, null);
            return new String(outputStream.toByteArray(), ISO_8859_1).split(EOL);
        }
        catch (CoreException e) {
            this.logError(e);
        }
        catch (UnsupportedEncodingException e) {
            this.logError(e);
        }
        return new String[0];
    }

    private void logError(Throwable e) {
        this.log.log((IStatus)new Status(4, this.bundleId, this.textAccessor.getText("recorder.error.message"), e));
    }
}

