/*
 * Decompiled with CFR 0.152.
 */
package ch.netcetera.eclipse.workspaceconfig.ui.preferences;

import ch.netcetera.eclipse.workspaceconfig.ui.preferences.ConfigurationUtil;
import ch.netcetera.eclipse.workspaceconfig.ui.preferences.api.IEpfUrlProvider;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;

public class WorkspaceConfigPreferenceInitializer
extends AbstractPreferenceInitializer {
    private static final String EXTENSION_ID = "ch.netcetera.eclipse.workspace.defaultConfiguration";
    private static final String EPF_URL = "EpfUrl";
    private static final String URL = "url";
    private static final String EPF_URL_PROVIDER = "EpfUrlProvider";
    private static final String CLASS = "class";
    private static final String NEW_WORKSPACE_DETECTION = "NewWorkspaceDetection";
    private static final String DETECT_NEW_WORKSPACES = "detectNewWorkspaces";
    private static final String JAVA_SYSTEM_PROPERTY_REPLACEMENT = "JavaSystemPropertyReplacement";
    private static final String SYSTEM_PROPERTY = "systemProperty";

    public void initializeDefaultPreferences() {
        IConfigurationElement[] configElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_ID);
        HashSet<String> urls = new HashSet<String>();
        HashSet<String> replacements = new HashSet<String>();
        boolean newWorkspaceDetection = false;
        IConfigurationElement[] iConfigurationElementArray = configElements;
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            String replacement;
            IConfigurationElement configElement = iConfigurationElementArray[n2];
            String elementName = configElement.getName();
            if (EPF_URL.equals(elementName)) {
                String url = configElement.getAttribute(URL);
                if (url != null && !url.isEmpty()) {
                    urls.add(url);
                }
            } else if (EPF_URL_PROVIDER.equals(elementName)) {
                urls.addAll(this.handleEpfUrlProvider(configElement));
            } else if (NEW_WORKSPACE_DETECTION.equals(elementName)) {
                newWorkspaceDetection |= Boolean.parseBoolean(configElement.getAttribute(DETECT_NEW_WORKSPACES));
            } else if (JAVA_SYSTEM_PROPERTY_REPLACEMENT.equals(elementName) && (replacement = configElement.getAttribute(SYSTEM_PROPERTY)) != null && !replacement.isEmpty()) {
                replacements.add(replacement);
            }
            ++n2;
        }
        ConfigurationUtil.saveEpfUrls(urls);
        ConfigurationUtil.saveEnvReplacements(replacements);
        ConfigurationUtil.saveNewWorkspaceDetection(newWorkspaceDetection);
    }

    private Collection<? extends String> handleEpfUrlProvider(IConfigurationElement configElement) {
        HashSet<String> urls = new HashSet<String>();
        try {
            IEpfUrlProvider urlProvider;
            String epfUrl;
            Object executableExtension = configElement.createExecutableExtension(CLASS);
            if (executableExtension instanceof IEpfUrlProvider && (epfUrl = (urlProvider = (IEpfUrlProvider)executableExtension).getEpfUrl()) != null && !epfUrl.isEmpty()) {
                urls.add(epfUrl);
            }
        }
        catch (CoreException coreException) {}
        return urls;
    }
}

