/*
 * Decompiled with CFR 0.152.
 */
package ch.netcetera.eclipse.workspaceconfig.ui.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.framework.FrameworkUtil;

public final class WorkspaceConfigurationStatusUtil {
    private static final String DATEFORMAT_PATTERN = "yyyy-MM-dd HH:mm:ss";
    private static final String NO_CONFIG = "NO_CONFIG";
    private static final String ERROR = "ERROR ";

    private WorkspaceConfigurationStatusUtil() {
        throw new AssertionError((Object)"Instantiation not allowed.");
    }

    public static boolean isNewWorkspace() {
        return WorkspaceConfigurationStatusUtil.getConfigurationAttribute().length() == 0;
    }

    public static void writeConfiguredFlag(IStatus status) {
        if (status.isOK()) {
            WorkspaceConfigurationStatusUtil.writeConfiguredAttribute(WorkspaceConfigurationStatusUtil.getFormattedTimestamp());
        } else {
            WorkspaceConfigurationStatusUtil.writeErrorFlag();
        }
    }

    public static void writeConfiguredFlag() {
        WorkspaceConfigurationStatusUtil.writeConfiguredAttribute(WorkspaceConfigurationStatusUtil.getFormattedTimestamp());
    }

    public static void writeNoConfigFlag() {
        WorkspaceConfigurationStatusUtil.writeConfiguredAttribute(NO_CONFIG);
    }

    public static void writeErrorFlag() {
        WorkspaceConfigurationStatusUtil.writeConfiguredAttribute(ERROR + WorkspaceConfigurationStatusUtil.getFormattedTimestamp());
    }

    private static void writeConfiguredAttribute(String value) {
        IEclipsePreferences rootNode = InstanceScope.INSTANCE.getNode(FrameworkUtil.getBundle(WorkspaceConfigurationStatusUtil.class).getSymbolicName());
        if (rootNode != null) {
            rootNode.put("CONFIGURED_V3", value);
        }
    }

    public static boolean isUnconfiguredWorkspace() {
        String value = WorkspaceConfigurationStatusUtil.getConfigurationAttribute();
        return value != null && value.equals(NO_CONFIG);
    }

    private static String getConfigurationAttribute() {
        return Platform.getPreferencesService().getString(FrameworkUtil.getBundle(WorkspaceConfigurationStatusUtil.class).getSymbolicName(), "CONFIGURED_V3", "", null);
    }

    public static boolean isConfiguredWorkspace() {
        String value = WorkspaceConfigurationStatusUtil.getConfigurationAttribute();
        return value != null && !WorkspaceConfigurationStatusUtil.isErrorDuringConfiguration() && !value.equals(NO_CONFIG);
    }

    public static boolean isErrorDuringConfiguration() {
        String value = WorkspaceConfigurationStatusUtil.getConfigurationAttribute();
        return value != null && value.startsWith(ERROR);
    }

    public static String getConfigDate() {
        return WorkspaceConfigurationStatusUtil.getConfigurationAttribute();
    }

    public static String getErrorDate() {
        return WorkspaceConfigurationStatusUtil.getConfigurationAttribute().substring(ERROR.length());
    }

    private static String getFormattedTimestamp() {
        return new SimpleDateFormat(DATEFORMAT_PATTERN, Locale.US).format(new Date());
    }
}

