/*
 * Decompiled with CFR 0.152.
 */
package ch.netcetera.eclipse.common.dialog;

import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ComboSelectionDialog
extends Dialog {
    private String fSelection = null;
    private final String fShellTitle;
    private final String fLabelText;
    private final List<String> fAllowedStrings;
    private final int fInitialSelectionIndex;

    public ComboSelectionDialog(Shell parentShell, String shellTitle, String labelText, List<String> comboStrings, int initialSelectionIndex) {
        super(parentShell);
        this.fShellTitle = shellTitle;
        this.fLabelText = labelText;
        this.fAllowedStrings = comboStrings;
        this.fInitialSelectionIndex = initialSelectionIndex;
    }

    public String getSelectedString() {
        return this.fSelection;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(this.fShellTitle);
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite innerComposite = new Composite(composite, 0);
        innerComposite.setLayoutData((Object)new GridData());
        GridLayout gl = new GridLayout();
        gl.numColumns = 1;
        innerComposite.setLayout((Layout)gl);
        Label label = new Label(innerComposite, 0);
        label.setText(this.fLabelText);
        label.setLayoutData((Object)new GridData());
        final Combo combo = new Combo(innerComposite, 8);
        for (String item : this.fAllowedStrings) {
            combo.add(item);
        }
        combo.select(this.fInitialSelectionIndex);
        this.fSelection = combo.getItem(combo.getSelectionIndex());
        GridData gd = new GridData();
        int widthHint = this.convertWidthInCharsToPixels(this.getMaxStringLength()) + 21;
        gd.widthHint = widthHint <= this.getParentShell().getSize().x ? widthHint : this.getParentShell().getSize().x - 42;
        combo.setLayoutData((Object)gd);
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ComboSelectionDialog.this.fSelection = combo.getItem(combo.getSelectionIndex());
            }
        });
        ComboSelectionDialog.applyDialogFont((Control)composite);
        return composite;
    }

    private int getMaxStringLength() {
        int max = 0;
        for (String item : this.fAllowedStrings) {
            max = Math.max(max, item.length());
        }
        return max;
    }
}

