/*
 * Decompiled with CFR 0.152.
 */
package ch.netcetera.eclipse.common.fieldeditor;

import ch.netcetera.eclipse.common.text.ITextAccessor;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractEditableStringListFieldEditor
extends FieldEditor {
    private org.eclipse.swt.widgets.List list;
    private SelectionAdapter listSelectionListener;
    private Composite buttonPanel;
    private Button addButton;
    private SelectionListener addButtonSelectionListener;
    private Button removeButton;
    private SelectionListener removeButtonSelectionListener;
    private Button editButton;
    private SelectionListener editButtonSelectionListener;
    private Button upButton;
    private SelectionListener upButtonSelectionListener;
    private Button downButton;
    private SelectionListener downButtonSelectionListener;
    private final ITextAccessor textAccessor;
    private final boolean isReorderable;

    public AbstractEditableStringListFieldEditor(String name, String labelText, Composite parent, ITextAccessor textAccessor) {
        this(name, labelText, parent, textAccessor, false);
    }

    public AbstractEditableStringListFieldEditor(String name, String labelText, Composite parent, ITextAccessor textAccessor, boolean isReorderable) {
        this.textAccessor = textAccessor;
        this.isReorderable = isReorderable;
        this.init(name, labelText);
        this.createSelectionListeners();
        this.createControl(parent);
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Label control = this.getLabelControl(parent);
        GridData gridData = new GridData();
        gridData.horizontalSpan = numColumns;
        control.setLayoutData((Object)gridData);
        this.list = this.createListControl(parent);
        gridData = new GridData(768);
        gridData.verticalAlignment = 4;
        gridData.horizontalSpan = numColumns - 1;
        gridData.grabExcessHorizontalSpace = true;
        this.list.setLayoutData((Object)gridData);
        this.buttonPanel = this.createButtonBoxControl(parent);
        gridData = new GridData();
        gridData.verticalAlignment = 1;
        this.buttonPanel.setLayoutData((Object)gridData);
    }

    private org.eclipse.swt.widgets.List createListControl(Composite parent) {
        if (this.list == null) {
            this.list = new org.eclipse.swt.widgets.List(parent, 2820);
            this.list.setFont(parent.getFont());
            this.list.addSelectionListener((SelectionListener)this.listSelectionListener);
            this.list.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    AbstractEditableStringListFieldEditor.this.list = null;
                }
            });
        } else {
            this.checkParent((Control)this.list, parent);
        }
        return this.list;
    }

    public Composite createButtonBoxControl(Composite parent) {
        if (this.buttonPanel == null) {
            this.buttonPanel = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginWidth = 0;
            this.buttonPanel.setLayout((Layout)layout);
            this.addButton = this.createPushButton(this.buttonPanel, "preference.page.button.add", this.addButtonSelectionListener);
            this.editButton = this.createPushButton(this.buttonPanel, "preference.page.button.edit", this.editButtonSelectionListener);
            this.removeButton = this.createPushButton(this.buttonPanel, "preference.page.button.remove", this.removeButtonSelectionListener);
            if (this.isReorderable) {
                this.upButton = this.createPushButton(this.buttonPanel, "preference.page.button.up", this.upButtonSelectionListener);
                this.downButton = this.createPushButton(this.buttonPanel, "preference.page.button.down", this.downButtonSelectionListener);
            }
            this.buttonPanel.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    AbstractEditableStringListFieldEditor.this.addButton = null;
                    AbstractEditableStringListFieldEditor.this.removeButton = null;
                    AbstractEditableStringListFieldEditor.this.editButton = null;
                    AbstractEditableStringListFieldEditor.this.upButton = null;
                    AbstractEditableStringListFieldEditor.this.downButton = null;
                    AbstractEditableStringListFieldEditor.this.buttonPanel = null;
                }
            });
        } else {
            this.checkParent((Control)this.buttonPanel, parent);
        }
        this.selectionChanged();
        return this.buttonPanel;
    }

    protected Shell getAddButtonShell() {
        return this.addButton == null ? null : this.addButton.getShell();
    }

    protected Shell getEditButtonShell() {
        return this.editButton == null ? null : this.editButton.getShell();
    }

    private void createSelectionListeners() {
        this.addButtonSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractEditableStringListFieldEditor.this.setPresentsDefaultValue(false);
                String newItem = AbstractEditableStringListFieldEditor.this.getNewListItem();
                if (newItem != null) {
                    int index = AbstractEditableStringListFieldEditor.this.list.getSelectionIndex();
                    if (index >= 0) {
                        AbstractEditableStringListFieldEditor.this.list.add(newItem, index + 1);
                    } else {
                        AbstractEditableStringListFieldEditor.this.list.add(newItem);
                    }
                    AbstractEditableStringListFieldEditor.this.selectionChanged();
                }
            }
        };
        this.removeButtonSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractEditableStringListFieldEditor.this.setPresentsDefaultValue(false);
                int index = AbstractEditableStringListFieldEditor.this.list.getSelectionIndex();
                if (index >= 0) {
                    AbstractEditableStringListFieldEditor.this.list.remove(index);
                    AbstractEditableStringListFieldEditor.this.selectionChanged();
                }
            }
        };
        this.editButtonSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractEditableStringListFieldEditor.this.setPresentsDefaultValue(false);
                int index = AbstractEditableStringListFieldEditor.this.list.getSelectionIndex();
                if (index >= 0) {
                    String item = AbstractEditableStringListFieldEditor.this.editListItem(AbstractEditableStringListFieldEditor.this.list.getItem(index));
                    if (item != null && item.length() > 0) {
                        AbstractEditableStringListFieldEditor.this.list.setItem(index, item);
                    } else {
                        AbstractEditableStringListFieldEditor.this.list.remove(index);
                    }
                    AbstractEditableStringListFieldEditor.this.selectionChanged();
                }
            }
        };
        this.upButtonSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractEditableStringListFieldEditor.this.setPresentsDefaultValue(false);
                org.eclipse.swt.widgets.List itemList = AbstractEditableStringListFieldEditor.this.list;
                int index = itemList.getSelectionIndex();
                if (index >= 1) {
                    String item = itemList.getItem(index);
                    itemList.remove(index);
                    itemList.add(item, index - 1);
                    itemList.setSelection(index - 1);
                    AbstractEditableStringListFieldEditor.this.selectionChanged();
                }
            }
        };
        this.downButtonSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractEditableStringListFieldEditor.this.setPresentsDefaultValue(false);
                org.eclipse.swt.widgets.List itemList = AbstractEditableStringListFieldEditor.this.list;
                int index = itemList.getSelectionIndex();
                if (index >= 0 && index < itemList.getItemCount() - 1) {
                    String item = itemList.getItem(index);
                    itemList.remove(index);
                    itemList.add(item, index + 1);
                    itemList.setSelection(index + 1);
                    AbstractEditableStringListFieldEditor.this.selectionChanged();
                }
            }
        };
        this.listSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractEditableStringListFieldEditor.this.selectionChanged();
            }
        };
    }

    private Button createPushButton(Composite parent, String key, SelectionListener selectionListener) {
        Button button = new Button(parent, 8);
        button.setText(this.textAccessor.getText(key));
        button.setFont(parent.getFont());
        GridData data = new GridData(768);
        int widthHint = this.convertHorizontalDLUsToPixels((Control)button, 61);
        data.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData((Object)data);
        button.addSelectionListener(selectionListener);
        return button;
    }

    protected void selectionChanged() {
        int index = this.list.getSelectionIndex();
        this.removeButton.setEnabled(index >= 0);
        this.editButton.setEnabled(index >= 0);
        if (this.isReorderable) {
            this.upButton.setEnabled(index >= 1);
            this.downButton.setEnabled(index >= 0 && index < this.list.getItemCount() - 1);
        }
    }

    public void setEnabled(boolean enabled, Composite parent) {
        super.setEnabled(enabled, parent);
        this.list.setEnabled(enabled);
        this.addButton.setEnabled(enabled);
        this.removeButton.setEnabled(enabled);
        this.editButton.setEnabled(enabled);
        if (this.isReorderable) {
            this.upButton.setEnabled(enabled);
            this.downButton.setEnabled(enabled);
        }
    }

    public void setFocus() {
        if (this.list != null) {
            this.list.setFocus();
        }
    }

    public int getNumberOfControls() {
        return 2;
    }

    protected void adjustForNumColumns(int numColumns) {
        Label control = this.getLabelControl();
        ((GridData)control.getLayoutData()).horizontalSpan = numColumns;
        ((GridData)this.list.getLayoutData()).horizontalSpan = numColumns - 1;
    }

    protected void doLoad() {
        if (this.list != null) {
            String preferenceString = this.getPreferenceStore().getString(this.getPreferenceName());
            List<String> valueList = this.parsePreferenceString(preferenceString);
            for (String item : valueList) {
                this.list.add(item);
            }
        }
    }

    protected abstract List<String> parsePreferenceString(String var1);

    protected void doLoadDefault() {
        if (this.list != null) {
            this.list.removeAll();
            String preferenceString = this.getPreferenceStore().getDefaultString(this.getPreferenceName());
            List<String> valueList = this.parsePreferenceString(preferenceString);
            for (String item : valueList) {
                this.list.add(item);
            }
        }
    }

    protected void doStore() {
        String s = this.marshallPreferenceString(this.list.getItems());
        if (s != null) {
            this.getPreferenceStore().setValue(this.getPreferenceName(), s);
        }
    }

    protected abstract String marshallPreferenceString(String[] var1);

    public ITextAccessor getTextAccessor() {
        return this.textAccessor;
    }

    public List<String> getListItems() {
        return Arrays.asList(this.list.getItems());
    }

    public abstract String getNewListItem();

    public abstract String editListItem(String var1);
}

