/*
 * Decompiled with CFR 0.152.
 */
package ch.netcetera.eclipse.common.validator;

import ch.netcetera.eclipse.common.text.ITextAccessor;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.IInputValidator;

public final class UriInputValidator
implements IInputValidator {
    private final List<String> itemList;
    private final ITextAccessor textAccessor;

    public UriInputValidator(List<String> uris, String itemToEdit, ITextAccessor textAccessor) {
        this.textAccessor = textAccessor;
        this.itemList = new ArrayList<String>(uris.size());
        this.itemList.addAll(uris);
        if (itemToEdit != null) {
            this.itemList.remove(itemToEdit);
        }
    }

    public String isValid(String text) {
        block7: {
            if (text == null || text.trim().isEmpty()) {
                return null;
            }
            String trimmedText = text.trim();
            String trimmedTextLower = trimmedText.toLowerCase();
            if (!(trimmedText.toLowerCase().startsWith("http:/") || trimmedTextLower.startsWith("https:/") || trimmedText.toLowerCase().startsWith("file:/"))) {
                return this.textAccessor.getText("url.validation.error.unsupported");
            }
            if (trimmedText.contains("#")) {
                return this.textAccessor.getText("url.validation.error.invalidchar");
            }
            if (this.itemList.contains(trimmedText)) {
                return this.textAccessor.getText("url.validation.error.notunique");
            }
            try {
                URI uri = new URI(trimmedText);
                if (!trimmedTextLower.startsWith("http") && uri.getAuthority() != null) break block7;
                return null;
            }
            catch (URISyntaxException uRISyntaxException) {
                return this.textAccessor.getText("url.validation.error.invalid");
            }
        }
        return this.textAccessor.getText("url.validation.error.invalid");
    }
}

