/*
 * Decompiled with CFR 0.152.
 */
package ch.netcetera.eclipse.workspaceconfig.core.internal;

import ch.netcetera.eclipse.common.io.IOUtil;
import ch.netcetera.eclipse.workspaceconfig.core.internal.IReplacer;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;

public class BufferedReplacementInputStream
extends InputStream {
    private static final Charset ENCODING = Charset.forName("ISO-8859-1");
    private final StringBuffer buffer = new StringBuffer();
    private int pos = 0;
    private final IReplacer replacer;

    public BufferedReplacementInputStream(IReplacer replacer, InputStream stream) throws IOException {
        this.replacer = replacer;
        if (stream != null) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream, ENCODING));
            try {
                String line = reader.readLine();
                while (line != null) {
                    this.buffer.append(this.replace(line));
                    this.buffer.append('\n');
                    line = reader.readLine();
                }
            }
            finally {
                IOUtil.closeSilently((Closeable)reader);
            }
        }
    }

    private String replace(String line) {
        if (this.replacer != null) {
            return this.replacer.replace(line);
        }
        return line;
    }

    @Override
    public int read() throws IOException {
        if (this.pos < this.buffer.length()) {
            return this.buffer.codePointAt(this.pos++);
        }
        return -1;
    }
}

