/*
 * Decompiled with CFR 0.152.
 */
package ch.netcetera.eclipse.workspaceconfig.core.internal;

import ch.netcetera.eclipse.workspaceconfig.core.internal.IReplacer;
import java.util.List;

public class SystemPropertyReplacer
implements IReplacer {
    private static final String PREFIX_PATTERN = "\\$";
    private final List<String> replacementList;

    public SystemPropertyReplacer(List<String> replacementList) {
        this.replacementList = replacementList;
    }

    @Override
    public String replace(String in) {
        String out = in;
        for (String placeholder : this.replacementList) {
            String systemProperty = System.getProperty(placeholder);
            if (systemProperty == null) continue;
            out = out.replaceAll(PREFIX_PATTERN + placeholder, systemProperty);
        }
        return out;
    }
}

