/*
 * Decompiled with CFR 0.152.
 */
package ch.netcetera.eclipse.projectconfig.core.configurationcommands;

import ch.netcetera.eclipse.common.io.IOUtil;
import ch.netcetera.eclipse.common.text.ITextAccessor;
import ch.netcetera.eclipse.projectconfig.core.configurationcommands.AbstractProjectConfigurationCommand;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class DownloadProjectConfigurationCommand
extends AbstractProjectConfigurationCommand {
    private static final String SUBCOMMAND_OVERWRITE = "overwrite";
    private static final String PROTOCOL_PREFIX_HTTP = "http";
    private static final String PROTOCOL_PREFIX_FILE = "file";
    public static final String COMMAND_NAME = "download";

    public DownloadProjectConfigurationCommand(List<String> argumentList, ITextAccessor textAccessor, String pluginId, ILog log) {
        super(argumentList, textAccessor, pluginId, log);
    }

    @Override
    IStatus executeOnProject(IProject project) {
        String fileUrl = this.getFileUrl();
        IPath targetFilePath = project.getLocation().append(this.getTargetFileName());
        File targetFile = targetFilePath.toFile();
        IStatus status = Status.OK_STATUS;
        if (!targetFile.exists() || this.isOverwrite()) {
            if (fileUrl.toLowerCase().startsWith(PROTOCOL_PREFIX_HTTP)) {
                status = this.downloadFileFromHTTP(fileUrl, targetFile);
            } else if (fileUrl.toLowerCase().startsWith(PROTOCOL_PREFIX_FILE)) {
                status = this.downloadFileFromFile(fileUrl, targetFile);
            }
        }
        if (!status.isOK()) {
            this.getLog().log(status);
        }
        return status;
    }

    private IStatus downloadFileFromFile(String fileUrl, File targetFile) {
        IStatus status;
        block7: {
            status = Status.OK_STATUS;
            try {
                URI uri = new URI(fileUrl);
                if (uri.getAuthority() == null) {
                    File sourceFile = new File(uri);
                    if (sourceFile.canRead()) {
                        FileOutputStream outputStream = null;
                        FileInputStream inputStream = null;
                        try {
                            outputStream = new FileOutputStream(targetFile);
                            inputStream = new FileInputStream(sourceFile);
                            this.copyFile(inputStream, outputStream);
                        }
                        catch (Throwable throwable) {
                            IOUtil.closeSilently(outputStream);
                            IOUtil.closeSilently(inputStream);
                            throw throwable;
                        }
                        IOUtil.closeSilently((Closeable)outputStream);
                        IOUtil.closeSilently((Closeable)inputStream);
                        break block7;
                    }
                    status = this.createStatus(4, this.getTextAccessor().getText("error.cannot.read.local.file"));
                    break block7;
                }
                status = this.createStatus(4, this.getTextAccessor().getText("error.cannot.read.local.file"));
            }
            catch (IOException e) {
                status = this.createStatus(4, e.getLocalizedMessage(), e);
            }
            catch (URISyntaxException e) {
                status = this.createStatus(4, e.getLocalizedMessage(), e);
            }
        }
        return status;
    }

    private IStatus downloadFileFromHTTP(String fileUrl, File targetFile) {
        IStatus status;
        block5: {
            status = Status.OK_STATUS;
            DefaultHttpClient httpClient = new DefaultHttpClient();
            HttpGet httpGet = new HttpGet(fileUrl);
            try {
                HttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
                int httpStatus = response.getStatusLine().getStatusCode();
                if (httpStatus != 200) {
                    status = this.createStatus(4, response.getStatusLine().getReasonPhrase());
                    break block5;
                }
                FileOutputStream outputStream = null;
                InputStream inputStream = null;
                try {
                    outputStream = new FileOutputStream(targetFile);
                    inputStream = response.getEntity().getContent();
                    this.copyFile(inputStream, outputStream);
                }
                catch (Throwable throwable) {
                    IOUtil.closeSilently(outputStream);
                    IOUtil.closeSilently(inputStream);
                    throw throwable;
                }
                IOUtil.closeSilently((Closeable)outputStream);
                IOUtil.closeSilently((Closeable)inputStream);
            }
            catch (IOException e) {
                status = this.createStatus(4, e.getLocalizedMessage(), e);
            }
        }
        return status;
    }

    private void copyFile(InputStream inputStream, OutputStream outputStream) throws IOException {
        int len;
        byte[] buffer = new byte[8192];
        while ((len = inputStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, len);
        }
    }

    private boolean isOverwrite() {
        return this.getArgumentList().size() == 5 && SUBCOMMAND_OVERWRITE.equals(this.getArgumentList().get(1));
    }

    private String getTargetFileName() {
        return this.isOverwrite() ? this.getArgumentList().get(4) : this.getArgumentList().get(3);
    }

    private String getFileUrl() {
        return this.isOverwrite() ? this.getArgumentList().get(2) : this.getArgumentList().get(1);
    }

    @Override
    boolean isEnabled() {
        return this.getArgumentList() != null && (this.getArgumentList().size() == 4 || this.getArgumentList().size() == 5);
    }
}

