/*
 * Decompiled with CFR 0.152.
 */
package ch.netcetera.eclipse.projectconfig.core.internal;

import ch.netcetera.eclipse.common.io.IOUtil;
import ch.netcetera.eclipse.common.text.ITextAccessor;
import ch.netcetera.eclipse.projectconfig.core.IProjectConfigurationService;
import ch.netcetera.eclipse.projectconfig.core.ProjectConfigurationScript;
import ch.netcetera.eclipse.projectconfig.core.configurationcommands.IProjectConfigurationCommand;
import ch.netcetera.eclipse.projectconfig.core.internal.ProjectConfigurationParser;
import ch.netcetera.eclipse.projectconfig.net.IProjectConfigurationClient;
import ch.netcetera.eclipse.projectconfig.net.IProjectConfigurationScriptData;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.FrameworkUtil;

public class ProjectConfigurationService
implements IProjectConfigurationService {
    private static final String PROTOCOL_PREFIX_FILE = "file";
    private static final String PROTOCOL_PREFIX_HTTP = "http";
    private volatile IProjectConfigurationClient client;

    public void bindClient(IProjectConfigurationClient client) {
        this.client = client;
    }

    public void unbindClient(IProjectConfigurationClient client) {
        this.client = null;
    }

    @Override
    public IStatus runConfigurationScript(List<IProject> projectList, String scriptUrl, ITextAccessor textAccessor, String pluginId, ILog log) {
        ProjectConfigurationScript script = new ProjectConfigurationScript(scriptUrl);
        IStatus status = this.getProjectPropertiesScript(script, textAccessor, pluginId, log);
        if (status.isOK()) {
            status = this.runScriptOnProjects(projectList, script, textAccessor, pluginId);
        }
        return status;
    }

    private IStatus getProjectPropertiesScript(ProjectConfigurationScript script, ITextAccessor textAccessor, String pluginId, ILog log) {
        IStatus status = Status.OK_STATUS;
        String commandFileUrl = script.getUrl();
        if (commandFileUrl.toLowerCase().startsWith(PROTOCOL_PREFIX_HTTP)) {
            status = this.getProjectConfigurationScriptFromHTTP(script, textAccessor, pluginId, log);
        } else if (commandFileUrl.toLowerCase().startsWith(PROTOCOL_PREFIX_FILE)) {
            status = this.getProjectConfigurationScriptFromFile(script, textAccessor, pluginId, log);
        }
        return status;
    }

    private IStatus getProjectConfigurationScriptFromFile(ProjectConfigurationScript script, ITextAccessor textAccessor, String pluginId, ILog log) {
        IStatus importStatus;
        block10: {
            importStatus = Status.OK_STATUS;
            String bundleSymbolicName = FrameworkUtil.getBundle(this.getClass()).getSymbolicName();
            FileInputStream inputStream = null;
            try {
                File sourceFile = new File(new URI(script.getUrl()));
                if (sourceFile.canRead()) {
                    try {
                        inputStream = new FileInputStream(sourceFile);
                        ProjectConfigurationParser.parse(script, inputStream, textAccessor, pluginId, log);
                    }
                    catch (FileNotFoundException e) {
                        importStatus = this.wrapExceptionInErrorStatus(e);
                        IOUtil.closeSilently((Closeable)inputStream);
                        break block10;
                    }
                    catch (SecurityException e) {
                        try {
                            importStatus = this.wrapExceptionInErrorStatus(e);
                        }
                        catch (Throwable throwable) {
                            IOUtil.closeSilently(inputStream);
                            throw throwable;
                        }
                        IOUtil.closeSilently((Closeable)inputStream);
                        break block10;
                    }
                    IOUtil.closeSilently((Closeable)inputStream);
                    break block10;
                }
                importStatus = new Status(4, bundleSymbolicName, "Could not read local file.");
            }
            catch (IOException e) {
                importStatus = new Status(4, bundleSymbolicName, e.getLocalizedMessage(), (Throwable)e);
            }
            catch (URISyntaxException e) {
                importStatus = new Status(4, bundleSymbolicName, e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return importStatus;
    }

    private IStatus getProjectConfigurationScriptFromHTTP(ProjectConfigurationScript script, ITextAccessor textAccessor, String pluginId, ILog log) {
        IStatus importStatus = Status.OK_STATUS;
        if (this.client != null) {
            try {
                IProjectConfigurationScriptData file = this.client.getProjectConfiguationScriptFileData(script.getUrl(), (IProgressMonitor)new NullProgressMonitor());
                ProjectConfigurationParser.parse(script, new ByteArrayInputStream(file.getData()), textAccessor, pluginId, log);
            }
            catch (CoreException e) {
                importStatus = this.wrapExceptionInErrorStatus(e);
            }
            catch (IOException e) {
                importStatus = this.wrapExceptionInErrorStatus(e);
            }
        } else {
            String bundleSymbolicName = FrameworkUtil.getBundle(this.getClass()).getSymbolicName();
            importStatus = new Status(4, bundleSymbolicName, "could not obtain client service.");
        }
        return importStatus;
    }

    private IStatus runScriptOnProjects(List<IProject> projectList, ProjectConfigurationScript script, ITextAccessor textAccessor, String pluginId) {
        IStatus status = Status.OK_STATUS;
        if (script != null && script.getCommandList() != null) {
            boolean statusOK = true;
            List<IProjectConfigurationCommand> commandList = script.getCommandList();
            for (IProjectConfigurationCommand command : commandList) {
                statusOK &= command.execute(projectList).isOK();
            }
            if (!statusOK) {
                status = new Status(2, pluginId, textAccessor.getText("error.config"));
            }
        } else {
            status = new Status(2, pluginId, textAccessor.getText("error.config"));
        }
        return status;
    }

    private IStatus wrapExceptionInErrorStatus(Throwable t) {
        String bundleSymbolicName = FrameworkUtil.getBundle(this.getClass()).getSymbolicName();
        return new Status(4, bundleSymbolicName, t.getLocalizedMessage(), t);
    }
}

