/*
 * Decompiled with CFR 0.152.
 */
package ch.netcetera.eclipse.workspaceconfig.ui;

import ch.netcetera.eclipse.workspaceconfig.core.IPreferencesImportService;
import ch.netcetera.eclipse.workspaceconfig.ui.RemotePreferencesImportPage;
import ch.netcetera.eclipse.workspaceconfig.ui.WorkspaceConfigurationUIPlugin;
import ch.netcetera.eclipse.workspaceconfig.ui.preferences.ConfigurationUtil;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public class RemotePreferencesImportWizard
extends Wizard
implements IImportWizard {
    private RemotePreferencesImportPage wizardPage;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(WorkspaceConfigurationUIPlugin.getDefault().getText("import.wizard.title"));
        this.setDefaultPageImageDescriptor(WorkspaceConfigurationUIPlugin.getImageDescriptor("rsrc/import_wizban.png"));
    }

    public void addPages() {
        super.addPages();
        this.wizardPage = new RemotePreferencesImportPage();
        this.addPage((IWizardPage)this.wizardPage);
    }

    public boolean performFinish() {
        List<String> importUrlList = this.wizardPage.getImportUrlList();
        IPreferencesImportService service = WorkspaceConfigurationUIPlugin.getDefault().getPreferencesImportService();
        List<Object> variableSubstitutionList = Collections.emptyList();
        if (this.wizardPage.doVariableSubstitution()) {
            variableSubstitutionList = ConfigurationUtil.getEnvReplacements();
        }
        for (String string : importUrlList) {
            IStatus status = service.importConfigFile(string, variableSubstitutionList);
            if (status.isOK()) continue;
            WorkspaceConfigurationUIPlugin.getDefault().getLog().log(status);
        }
        return true;
    }
}

