/*
 * Decompiled with CFR 0.152.
 */
package ch.netcetera.eclipse.workspaceconfig.ui.preferences;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collection;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class ConfigurationXMLMarshaler {
    private static final String ENCODING = "ISO-8859-1";
    private final XMLOutputFactory factory = XMLOutputFactory.newInstance();

    ConfigurationXMLMarshaler() {
    }

    public String marshalEpfUrlList(Collection<String> epfUrls) throws IOException {
        return this.marshalList("epfurls", "epfurl", epfUrls);
    }

    public String marshalEnvVarList(Collection<String> envVarList) throws IOException {
        return this.marshalList("envvars", "envvar", envVarList);
    }

    private String marshalList(String rootElement, String itemElement, Collection<String> envVarList) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            XMLStreamWriter writer = this.factory.createXMLStreamWriter(output, ENCODING);
            writer.writeStartDocument(ENCODING, "1.0");
            writer.writeStartElement(rootElement);
            for (String envVar : envVarList) {
                writer.writeStartElement(itemElement);
                writer.writeCharacters(envVar);
                writer.writeEndElement();
            }
            writer.writeEndElement();
            writer.writeEndDocument();
            writer.flush();
            return output.toString(ENCODING);
        }
        catch (XMLStreamException e) {
            throw new IOException("Could not export list to xml.", e);
        }
    }
}

