/*
 * Decompiled with CFR 0.152.
 */
package ch.netcetera.eclipse.common.preference;

import ch.netcetera.eclipse.common.security.SecurePreferencesUtil;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class SecurePreferenceStringFieldEditor
extends StringFieldEditor {
    private static final String DEFAULT_VALUE = "";
    private final Text textControl;
    private final String nodePathName;

    public SecurePreferenceStringFieldEditor(String name, String labelText, Composite parent, char echoCharacter, String nodePathName) {
        this.nodePathName = nodePathName;
        this.init(name, labelText);
        this.createControl(parent);
        this.textControl = this.getTextControl();
        this.textControl.setEchoChar(echoCharacter);
    }

    protected void doLoad() {
        if (this.textControl != null && this.isEnabled()) {
            String value = DEFAULT_VALUE;
            try {
                value = SecurePreferencesUtil.get(this.nodePathName, this.getPreferenceName());
            }
            catch (StorageException storageException) {}
            this.textControl.setText(value);
            this.oldValue = value;
        }
    }

    protected void doLoadDefault() {
        if (this.textControl != null) {
            this.textControl.setText(DEFAULT_VALUE);
        }
        this.valueChanged();
    }

    protected void doStore() {
        if (this.isEnabled()) {
            try {
                SecurePreferencesUtil.store(this.nodePathName, this.getPreferenceName(), this.textControl.getText().trim());
            }
            catch (StorageException storageException) {}
        }
    }

    public void setEnabled(boolean enabled, Composite parent) {
        super.setEnabled(enabled, parent);
        if (!enabled) {
            this.setStringValue(DEFAULT_VALUE);
            SecurePreferencesUtil.removeSilently(this.nodePathName, this.getPreferenceName());
        }
    }

    private boolean isEnabled() {
        return this.getTextControl().isEnabled();
    }
}

