/*
 * Decompiled with CFR 0.152.
 */
package ch.netcetera.eclipse.common.validator;

import ch.netcetera.eclipse.common.text.ITextAccessor;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.IInputValidator;

public final class StringListInputValidator
implements IInputValidator {
    private final List<String> itemList;
    private final ITextAccessor textAccessor;

    public StringListInputValidator(List<String> variableList, String itemToEdit, ITextAccessor textAccessor) {
        this.textAccessor = textAccessor;
        this.itemList = new ArrayList<String>(variableList);
        if (itemToEdit != null) {
            this.itemList.remove(itemToEdit);
        }
    }

    public String isValid(String text) {
        if (text == null || text.trim().isEmpty()) {
            return null;
        }
        String trimmedText = text.trim();
        if (trimmedText.contains("#")) {
            return this.textAccessor.getText("var.validation.error.invalidchar");
        }
        if (this.itemList.contains(trimmedText)) {
            return this.textAccessor.getText("var.validation.error.notunique");
        }
        return null;
    }
}

