/*
 * Decompiled with CFR 0.152.
 */
package ch.netcetera.eclipse.workspaceconfig.core.internal;

import ch.netcetera.eclipse.common.io.IOUtil;
import ch.netcetera.eclipse.workspaceconfig.core.IPreferencesImportService;
import ch.netcetera.eclipse.workspaceconfig.core.internal.BufferedReplacementInputStream;
import ch.netcetera.eclipse.workspaceconfig.core.internal.SystemPropertyReplacer;
import ch.netcetera.eclipse.workspaceconfig.net.IPreferenceFileData;
import ch.netcetera.eclipse.workspaceconfig.net.IWorkspacePreferenceClient;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IExportedPreferences;
import org.eclipse.core.runtime.preferences.IPreferenceFilter;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.osgi.framework.FrameworkUtil;

public class PreferencesImportService
implements IPreferencesImportService {
    private static final String PROTOCOL_PREFIX_FILE = "file";
    private static final String PROTOCOL_PREFIX_HTTP = "http";
    private volatile IWorkspacePreferenceClient client;

    public void bindClient(IWorkspacePreferenceClient client) {
        this.client = client;
    }

    public void unbindClient(IWorkspacePreferenceClient client) {
        this.client = null;
    }

    @Override
    public IStatus importConfigFile(String url, List<String> systemPropertyReplacementList) {
        IStatus importStatus = Status.OK_STATUS;
        if (url.toLowerCase().startsWith(PROTOCOL_PREFIX_HTTP)) {
            importStatus = this.importConfigFileHttp(url, systemPropertyReplacementList);
        } else if (url.toLowerCase().startsWith(PROTOCOL_PREFIX_FILE)) {
            importStatus = this.importConfigFileFile(url, systemPropertyReplacementList);
        }
        return importStatus;
    }

    /*
     * Loose catch block
     */
    private IStatus importConfigFileFile(String url, List<String> systemPropertyReplacementList) {
        IStatus importStatus;
        block13: {
            String bundleSymbolicName = FrameworkUtil.getBundle(this.getClass()).getSymbolicName();
            importStatus = Status.OK_STATUS;
            FileInputStream inputStream = null;
            try {
                URI uri = new URI(url);
                if (uri.getAuthority() == null) {
                    File sourceFile = new File(uri);
                    if (sourceFile.canRead()) {
                        try {
                            inputStream = new FileInputStream(sourceFile);
                            this.importConfigurationFromStream(inputStream, systemPropertyReplacementList);
                        }
                        catch (FileNotFoundException e) {
                            importStatus = this.wrapExceptionInErrorStatus(e);
                            IOUtil.closeSilently((Closeable)inputStream);
                            break block13;
                        }
                        catch (SecurityException e) {
                            importStatus = this.wrapExceptionInErrorStatus(e);
                            IOUtil.closeSilently((Closeable)inputStream);
                            break block13;
                        }
                        catch (CoreException e) {
                            importStatus = this.wrapExceptionInErrorStatus(e);
                            {
                                catch (Throwable throwable) {
                                    IOUtil.closeSilently(inputStream);
                                    throw throwable;
                                }
                            }
                            IOUtil.closeSilently((Closeable)inputStream);
                            break block13;
                        }
                        IOUtil.closeSilently((Closeable)inputStream);
                        break block13;
                    }
                    importStatus = new Status(4, bundleSymbolicName, "Could not read local file.");
                    break block13;
                }
                importStatus = new Status(4, bundleSymbolicName, "The file url is invalid.");
            }
            catch (IOException e) {
                importStatus = new Status(4, bundleSymbolicName, e.getLocalizedMessage(), (Throwable)e);
            }
            catch (URISyntaxException e) {
                importStatus = new Status(4, bundleSymbolicName, e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return importStatus;
    }

    private IStatus importConfigFileHttp(String url, List<String> systemPropertyReplacementList) {
        IStatus importStatus = Status.OK_STATUS;
        if (this.client != null) {
            try {
                IPreferenceFileData file = this.client.getPreferenceFileData(url, (IProgressMonitor)new NullProgressMonitor());
                this.importConfigurationFromStream(new ByteArrayInputStream(file.getData()), systemPropertyReplacementList);
            }
            catch (CoreException e) {
                importStatus = this.wrapExceptionInErrorStatus(e);
            }
            catch (IOException e) {
                importStatus = this.wrapExceptionInErrorStatus(e);
            }
        } else {
            String bundleSymbolicName = FrameworkUtil.getBundle(this.getClass()).getSymbolicName();
            importStatus = new Status(4, bundleSymbolicName, "could not obtain client service.");
        }
        return importStatus;
    }

    private void importConfigurationFromStream(InputStream inputStream, List<String> systemPropertyReplacementList) throws CoreException, IOException {
        IPreferenceFilter[] transfers = this.getPreferenceImportFilters();
        SystemPropertyReplacer replacer = new SystemPropertyReplacer(systemPropertyReplacementList);
        BufferedReplacementInputStream input = new BufferedReplacementInputStream(replacer, inputStream);
        IPreferencesService service = Platform.getPreferencesService();
        IExportedPreferences preferences = service.readPreferences((InputStream)input);
        service.applyPreferences((IEclipsePreferences)preferences, transfers);
    }

    private IPreferenceFilter[] getPreferenceImportFilters() {
        IPreferenceFilter filter = new IPreferenceFilter(){

            public String[] getScopes() {
                return new String[]{"instance", "configuration"};
            }

            public Map getMapping(String scope) {
                return null;
            }
        };
        return new IPreferenceFilter[]{filter};
    }

    private IStatus wrapExceptionInErrorStatus(Throwable t) {
        String bundleSymbolicName = FrameworkUtil.getBundle(this.getClass()).getSymbolicName();
        return new Status(4, bundleSymbolicName, t.getLocalizedMessage(), t);
    }
}

