/*
 * Decompiled with CFR 0.152.
 */
package ch.netcetera.eclipse.projectconfig.ui.handler;

import ch.netcetera.eclipse.common.text.ITextAccessor;
import ch.netcetera.eclipse.projectconfig.core.IProjectConfigurationService;
import ch.netcetera.eclipse.projectconfig.ui.ProjectConfigurationUIPlugin;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class ProjectConfiurationJob
extends Job {
    private final List<IProject> projectList;
    private final String pluginId;
    private final String scriptUrl;
    private final ILog log;
    private final ITextAccessor textAccessor;

    public ProjectConfiurationJob(String name, String pluginId, List<IProject> projectList, String scriptUrl, ILog log, ITextAccessor textAccessor) {
        super(name);
        this.pluginId = pluginId;
        this.projectList = projectList;
        this.scriptUrl = scriptUrl;
        this.log = log;
        this.textAccessor = textAccessor;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            return this.runConfigurationScript();
        }
        catch (ExecutionException e) {
            return new Status(4, this.pluginId, e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private IStatus runConfigurationScript() throws ExecutionException {
        IStatus status = Status.OK_STATUS;
        if (this.scriptUrl != null && this.scriptUrl.trim().length() > 0) {
            IProjectConfigurationService service = ProjectConfigurationUIPlugin.getDefault().getProjectConfigurationService();
            if (service != null) {
                status = service.runConfigurationScript(this.projectList, this.scriptUrl, this.textAccessor, this.pluginId, this.log);
                this.refreshProjects();
            } else {
                status = new Status(4, this.pluginId, "ProjectConfiurationJob could not obtain service reference of IProjectConfigurationService");
            }
        }
        return status;
    }

    private void refreshProjects() {
        if (this.projectList != null) {
            for (IProject project : this.projectList) {
                try {
                    project.refreshLocal(2, null);
                }
                catch (CoreException coreException) {}
            }
        }
    }
}

