/*
 * Decompiled with CFR 0.152.
 */
package ch.netcetera.eclipse.projectconfig.ui.handler;

import ch.netcetera.eclipse.common.dialog.ComboSelectionDialog;
import ch.netcetera.eclipse.common.squasher.PreferenceListSquasher;
import ch.netcetera.eclipse.common.text.ITextAccessor;
import ch.netcetera.eclipse.projectconfig.ui.ProjectConfigurationUIPlugin;
import ch.netcetera.eclipse.projectconfig.ui.handler.ProjectConfiurationJob;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class RunProjectConfigurationScriptHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        List<IProject> projectList = this.getProjectsFromSelection(selection);
        if (!projectList.isEmpty()) {
            String scriptUrl = this.getScriptURL();
            ProjectConfiurationJob job = new ProjectConfiurationJob(ProjectConfigurationUIPlugin.getDefault().getText("project.config.job.name"), "ch.netcetera.eclipse.projectconfig.ui", projectList, scriptUrl, ProjectConfigurationUIPlugin.getDefault().getLog(), (ITextAccessor)ProjectConfigurationUIPlugin.getDefault());
            job.setUser(true);
            job.schedule();
        }
        return null;
    }

    private String getScriptURL() {
        IPreferenceStore preferenceStore = ProjectConfigurationUIPlugin.getDefault().getPreferenceStore();
        List urls = PreferenceListSquasher.splitListItemsToStringArray((String)preferenceStore.getString("CONFIG_CMDFILE_URL"));
        String scriptUrl = "";
        if (urls.size() == 1) {
            scriptUrl = (String)urls.get(0);
        } else if (urls.size() > 1) {
            ComboSelectionDialog selectionDialog = new ComboSelectionDialog(ProjectConfigurationUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), ProjectConfigurationUIPlugin.getDefault().getText("apply.config.dialog.title"), ProjectConfigurationUIPlugin.getDefault().getText("apply.config.dialog.label"), urls, 0);
            selectionDialog.open();
            if (selectionDialog.getReturnCode() == 0) {
                scriptUrl = selectionDialog.getSelectedString();
            }
        }
        return scriptUrl;
    }

    private List<IProject> getProjectsFromSelection(ISelection selection) {
        IStructuredSelection currentSelection;
        ArrayList<IProject> projectList = new ArrayList<IProject>();
        if (selection instanceof IStructuredSelection && !(currentSelection = (IStructuredSelection)selection).isEmpty()) {
            for (IAdaptable selectedObject : currentSelection) {
                if (selectedObject instanceof IJavaProject) {
                    IJavaProject javaProject = (IJavaProject)selectedObject;
                    projectList.add(javaProject.getProject());
                    continue;
                }
                if (!(selectedObject instanceof IProject)) continue;
                projectList.add(((IProject)selectedObject).getProject());
            }
        }
        return projectList;
    }
}

