/*
 * Decompiled with CFR 0.152.
 */
package ch.netcetera.eclipse.workspaceconfig.net.internal;

import ch.netcetera.eclipse.common.io.IOUtil;
import ch.netcetera.eclipse.common.net.AbstractHttpClient;
import ch.netcetera.eclipse.workspaceconfig.net.IPreferenceFileData;
import ch.netcetera.eclipse.workspaceconfig.net.IWorkspacePreferenceClient;
import ch.netcetera.eclipse.workspaceconfig.net.internal.PreferenceFileData;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.HttpResponse;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class WorkspacePreferenceClient
extends AbstractHttpClient
implements IWorkspacePreferenceClient {
    protected String getBundleSymbolicName() {
        Bundle bundle = FrameworkUtil.getBundle(this.getClass());
        if (bundle == null) {
            return this.getClass().getPackage().getName();
        }
        return bundle.getSymbolicName();
    }

    @Override
    public IPreferenceFileData getPreferenceFileData(String url, IProgressMonitor monitor) throws CoreException {
        return (IPreferenceFileData)this.executeGetRequest(url, new PreferenceFileResponseHandler(), monitor);
    }

    protected IPreferenceFileData handleResponse(HttpResponse response, IProgressMonitor monitor) throws IOException {
        InputStream input = response.getEntity().getContent();
        try {
            monitor.subTask("Transfering data from server...");
            input = this.wrapResponseStream(response, input, monitor);
            monitor.subTask("Parsing data..");
            ByteArrayOutputStream output = new ByteArrayOutputStream(8192);
            WorkspacePreferenceClient.copy((InputStream)input, (OutputStream)output);
            PreferenceFileData preferenceFileData = new PreferenceFileData(output.toByteArray());
            return preferenceFileData;
        }
        finally {
            IOUtil.closeSilently((Closeable)input);
        }
    }

    final class PreferenceFileResponseHandler
    implements AbstractHttpClient.IResponseHandler<IPreferenceFileData> {
        PreferenceFileResponseHandler() {
        }

        public IPreferenceFileData handleResponse(HttpResponse response, IProgressMonitor monitor) throws IOException {
            return WorkspacePreferenceClient.this.handleResponse(response, monitor);
        }
    }
}

