/*
 * Decompiled with CFR 0.152.
 */
package ch.netcetera.eclipse.projectconfig.net.internal;

import ch.netcetera.eclipse.common.io.IOUtil;
import ch.netcetera.eclipse.common.net.AbstractHttpClient;
import ch.netcetera.eclipse.projectconfig.net.IProjectConfigurationClient;
import ch.netcetera.eclipse.projectconfig.net.IProjectConfigurationScriptData;
import ch.netcetera.eclipse.projectconfig.net.internal.ProjectConfigurationScriptData;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.HttpResponse;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class ProjectConfigurationClient
extends AbstractHttpClient
implements IProjectConfigurationClient {
    protected String getBundleSymbolicName() {
        Bundle bundle = FrameworkUtil.getBundle(this.getClass());
        if (bundle == null) {
            return this.getClass().getPackage().getName();
        }
        return bundle.getSymbolicName();
    }

    @Override
    public IProjectConfigurationScriptData getProjectConfiguationScriptFileData(String url, IProgressMonitor monitor) throws CoreException {
        return (IProjectConfigurationScriptData)this.executeGetRequest(url, new PreferenceFileResponseHandler(), monitor);
    }

    protected IProjectConfigurationScriptData handleResponse(HttpResponse response, IProgressMonitor monitor) throws IOException {
        InputStream input = response.getEntity().getContent();
        ByteArrayOutputStream output = null;
        try {
            monitor.subTask("Transfering data from server..");
            input = this.wrapResponseStream(response, input, monitor);
            monitor.subTask("Parsing data..");
            output = new ByteArrayOutputStream(8192);
            ProjectConfigurationClient.copy((InputStream)input, (OutputStream)output);
            ProjectConfigurationScriptData projectConfigurationScriptData = new ProjectConfigurationScriptData(output.toByteArray());
            return projectConfigurationScriptData;
        }
        finally {
            IOUtil.closeSilently((Closeable)input);
        }
    }

    final class PreferenceFileResponseHandler
    implements AbstractHttpClient.IResponseHandler<IProjectConfigurationScriptData> {
        PreferenceFileResponseHandler() {
        }

        public IProjectConfigurationScriptData handleResponse(HttpResponse response, IProgressMonitor monitor) throws IOException {
            return ProjectConfigurationClient.this.handleResponse(response, monitor);
        }
    }
}

