/*
 * Decompiled with CFR 0.152.
 */
package ch.netcetera.eclipse.projectconfig.core.configurationcommands;

import ch.netcetera.eclipse.common.text.ITextAccessor;
import ch.netcetera.eclipse.projectconfig.core.configurationcommands.IProjectConfigurationCommand;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public abstract class AbstractProjectConfigurationCommand
implements IProjectConfigurationCommand {
    private final List<String> argumentList;
    private final ITextAccessor textAccessor;
    private final String pluginId;
    private final ILog log;

    AbstractProjectConfigurationCommand(List<String> argumentList, ITextAccessor textAccessor, String pluginId, ILog log) {
        this.argumentList = argumentList;
        this.textAccessor = textAccessor;
        this.pluginId = pluginId;
        this.log = log;
    }

    List<String> getArgumentList() {
        return this.argumentList;
    }

    @Override
    public IStatus execute(List<IProject> projectList) {
        IStatus globalResult = Status.OK_STATUS;
        boolean error = false;
        if (projectList != null && !projectList.isEmpty() && this.isEnabled()) {
            for (IProject project : projectList) {
                IStatus result = this.executeOnProject(project);
                if (result.isOK()) continue;
                this.getLog().log(result);
                error = true;
            }
        }
        if (error) {
            globalResult = new Status(2, this.getPluginId(), this.getTextAccessor().getText("error.config"));
        }
        return globalResult;
    }

    abstract IStatus executeOnProject(IProject var1);

    abstract boolean isEnabled();

    ITextAccessor getTextAccessor() {
        return this.textAccessor;
    }

    String getPluginId() {
        return this.pluginId;
    }

    ILog getLog() {
        return this.log;
    }

    IStatus createStatus(int severity, String message, Throwable exception) {
        return new Status(severity, this.pluginId, this.textAccessor.getText(message), exception);
    }

    IStatus createStatus(int severity, String message) {
        return this.createStatus(severity, message, null);
    }
}

