/*
 * Decompiled with CFR 0.152.
 */
package ch.netcetera.eclipse.projectconfig.core.internal;

import ch.netcetera.eclipse.common.io.IOUtil;
import ch.netcetera.eclipse.common.text.ITextAccessor;
import ch.netcetera.eclipse.projectconfig.core.ProjectConfigurationScript;
import ch.netcetera.eclipse.projectconfig.core.configurationcommands.AddNatureProjectConfigurationCommand;
import ch.netcetera.eclipse.projectconfig.core.configurationcommands.CommentProjectConfigurationCommand;
import ch.netcetera.eclipse.projectconfig.core.configurationcommands.DownloadProjectConfigurationCommand;
import ch.netcetera.eclipse.projectconfig.core.configurationcommands.IProjectConfigurationCommand;
import ch.netcetera.eclipse.projectconfig.core.configurationcommands.MkdirProjectConfigurationCommand;
import ch.netcetera.eclipse.projectconfig.core.configurationcommands.RemoveNatureProjectConfigurationCommand;
import ch.netcetera.eclipse.projectconfig.core.configurationcommands.RmProjectConfigurationCommand;
import ch.netcetera.eclipse.projectconfig.core.configurationcommands.RmdirProjectConfigurationCommand;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.ILog;

final class ProjectConfigurationParser {
    private ProjectConfigurationParser() {
        throw new AssertionError((Object)"not instantiable");
    }

    static void parse(ProjectConfigurationScript script, InputStream inputStream, ITextAccessor textAccessor, String pluginId, ILog log) throws IOException {
        ArrayList<IProjectConfigurationCommand> commandList = new ArrayList<IProjectConfigurationCommand>();
        Charset charset = Charset.forName("ISO-8859-1");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, charset));
        try {
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                List<String> split = ProjectConfigurationParser.splitLine(line);
                if (split.isEmpty()) continue;
                String command = split.get(0);
                if (command.equals("#")) {
                    commandList.add(new CommentProjectConfigurationCommand(split, textAccessor, pluginId, log));
                    continue;
                }
                if (command.equals("download")) {
                    commandList.add(new DownloadProjectConfigurationCommand(split, textAccessor, pluginId, log));
                    continue;
                }
                if (command.equals("mkdir")) {
                    commandList.add(new MkdirProjectConfigurationCommand(split, textAccessor, pluginId, log));
                    continue;
                }
                if (command.equals("rmdir")) {
                    commandList.add(new RmdirProjectConfigurationCommand(split, textAccessor, pluginId, log));
                    continue;
                }
                if (command.equals("rm")) {
                    commandList.add(new RmProjectConfigurationCommand(split, textAccessor, pluginId, log));
                    continue;
                }
                if (command.equals("addnature")) {
                    commandList.add(new AddNatureProjectConfigurationCommand(split, textAccessor, pluginId, log));
                    continue;
                }
                if (!command.equals("removenature")) continue;
                commandList.add(new RemoveNatureProjectConfigurationCommand(split, textAccessor, pluginId, log));
            }
        }
        finally {
            IOUtil.closeSilently((Closeable)bufferedReader);
        }
        script.setCommands(commandList);
    }

    static List<String> splitLine(String line) {
        String[] split = line.trim().split(" ");
        ArrayList<String> list = new ArrayList<String>(split.length);
        String[] stringArray = split;
        int n = split.length;
        int n2 = 0;
        while (n2 < n) {
            String element2 = stringArray[n2];
            String element = element2.trim();
            if (element.length() > 0) {
                list.add(element);
            }
            ++n2;
        }
        return list;
    }
}

